import { getParsingFlags } from './parsing-flags';
export function isValid(config) {
    if (config._isValid == null) {
        const flags = getParsingFlags(config);
        const parsedParts = Array.prototype.some.call(flags.parsedDateParts, function (i) {
            return i != null;
        });
        let isNowValid = !isNaN(config._d && config._d.getTime()) &&
            flags.overflow < 0 &&
            !flags.empty &&
            !flags.invalidMonth &&
            !flags.invalidWeekday &&
            !flags.weekdayMismatch &&
            !flags.nullInput &&
            !flags.invalidFormat &&
            !flags.userInvalidated &&
            (!flags.meridiem || (flags.meridiem && parsedParts));
        if (config._strict) {
            isNowValid = isNowValid &&
                flags.charsLeftOver === 0 &&
                flags.unusedTokens.length === 0 &&
                flags.bigHour === undefined;
        }
        if (Object.isFrozen == null || !Object.isFrozen(config)) {
            config._isValid = isNowValid;
        }
        else {
            return isNowValid;
        }
    }
    return config._isValid;
}
export function createInvalid(config, flags) {
    config._d = new Date(NaN);
    Object.assign(getParsingFlags(config), flags || { userInvalidated: true });
    return config;
}
export function markInvalid(config) {
    config._isValid = false;
    return config;
}
//# sourceMappingURL=data:application/json;base64,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