import { Injectable, NgModule, Optional } from '@angular/core';
import { BaseChartDirective } from './base-chart.directive';
import { Chart, registerables, defaults } from 'chart.js';
import { merge } from "lodash-es";
import { builtInDefaults } from "./get-colors";
import * as i0 from "@angular/core";
export class NgChartsConfiguration {
}
NgChartsConfiguration.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NgChartsConfiguration, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
NgChartsConfiguration.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NgChartsConfiguration, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NgChartsConfiguration, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }] });
Chart.register(...registerables);
export class NgChartsModule {
    constructor(config) {
        if (config?.plugins)
            Chart.register(...config?.plugins);
        const ngChartsDefaults = merge(builtInDefaults, config?.defaults || {});
        defaults.set(ngChartsDefaults);
    }
    static forRoot(config) {
        return {
            ngModule: NgChartsModule,
            providers: [
                { provide: NgChartsConfiguration, useValue: config }
            ]
        };
    }
}
NgChartsModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NgChartsModule, deps: [{ token: NgChartsConfiguration, optional: true }], target: i0.ɵɵFactoryTarget.NgModule });
NgChartsModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.0.5", ngImport: i0, type: NgChartsModule, declarations: [BaseChartDirective], exports: [BaseChartDirective] });
NgChartsModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NgChartsModule });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NgChartsModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [],
                    declarations: [BaseChartDirective],
                    exports: [BaseChartDirective]
                }]
        }], ctorParameters: function () { return [{ type: NgChartsConfiguration, decorators: [{
                    type: Optional
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmctY2hhcnRzLm1vZHVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3Byb2plY3RzL25nMi1jaGFydHMvc3JjL2xpYi9uZy1jaGFydHMubW9kdWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQXVCLFFBQVEsRUFBRSxRQUFRLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDcEYsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0sd0JBQXdCLENBQUM7QUFDNUQsT0FBTyxFQUFFLEtBQUssRUFBRSxhQUFhLEVBQWdDLFFBQVEsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUN4RixPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ2xDLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxjQUFjLENBQUM7O0FBRy9DLE1BQU0sT0FBTyxxQkFBcUI7O2tIQUFyQixxQkFBcUI7c0hBQXJCLHFCQUFxQixjQURSLE1BQU07MkZBQ25CLHFCQUFxQjtrQkFEakMsVUFBVTttQkFBQyxFQUFFLFVBQVUsRUFBRSxNQUFNLEVBQUU7O0FBTWxDLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxhQUFhLENBQUMsQ0FBQztBQU9qQyxNQUFNLE9BQU8sY0FBYztJQUV6QixZQUF3QixNQUE4QjtRQUNwRCxJQUFJLE1BQU0sRUFBRSxPQUFPO1lBQ2pCLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxNQUFNLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFFckMsTUFBTSxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZUFBZSxFQUFFLE1BQU0sRUFBRSxRQUFRLElBQUksRUFBRSxDQUFDLENBQUM7UUFFeEUsUUFBUSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFTSxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQThCO1FBQ2xELE9BQU87WUFDTCxRQUFRLEVBQUUsY0FBYztZQUN4QixTQUFTLEVBQUU7Z0JBQ1QsRUFBRSxPQUFPLEVBQUUscUJBQXFCLEVBQUUsUUFBUSxFQUFFLE1BQU0sRUFBRTthQUNyRDtTQUNGLENBQUM7SUFDSixDQUFDOzsyR0FsQlUsY0FBYyxrQkFFUSxxQkFBcUI7NEdBRjNDLGNBQWMsaUJBSFQsa0JBQWtCLGFBQ3ZCLGtCQUFrQjs0R0FFbEIsY0FBYzsyRkFBZCxjQUFjO2tCQUwxQixRQUFRO21CQUFDO29CQUNSLE9BQU8sRUFBRSxFQUFFO29CQUNYLFlBQVksRUFBRSxDQUFFLGtCQUFrQixDQUFFO29CQUNwQyxPQUFPLEVBQUUsQ0FBRSxrQkFBa0IsQ0FBRTtpQkFDaEM7MERBR2tDLHFCQUFxQjswQkFBekMsUUFBUSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdGFibGUsIE1vZHVsZVdpdGhQcm92aWRlcnMsIE5nTW9kdWxlLCBPcHRpb25hbCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQmFzZUNoYXJ0RGlyZWN0aXZlIH0gZnJvbSAnLi9iYXNlLWNoYXJ0LmRpcmVjdGl2ZSc7XG5pbXBvcnQgeyBDaGFydCwgcmVnaXN0ZXJhYmxlcywgQ2hhcnRDb21wb25lbnRMaWtlLCBEZWZhdWx0cywgZGVmYXVsdHMgfSBmcm9tICdjaGFydC5qcyc7XG5pbXBvcnQgeyBtZXJnZSB9IGZyb20gXCJsb2Rhc2gtZXNcIjtcbmltcG9ydCB7IGJ1aWx0SW5EZWZhdWx0cyB9IGZyb20gXCIuL2dldC1jb2xvcnNcIjtcblxuQEluamVjdGFibGUoeyBwcm92aWRlZEluOiAncm9vdCcgfSlcbmV4cG9ydCBjbGFzcyBOZ0NoYXJ0c0NvbmZpZ3VyYXRpb24ge1xuICBwdWJsaWMgcGx1Z2lucz86IENoYXJ0Q29tcG9uZW50TGlrZVtdO1xuICBwdWJsaWMgZGVmYXVsdHM/OiBQYXJ0aWFsPERlZmF1bHRzPjtcbn1cblxuQ2hhcnQucmVnaXN0ZXIoLi4ucmVnaXN0ZXJhYmxlcyk7XG5cbkBOZ01vZHVsZSh7XG4gIGltcG9ydHM6IFtdLFxuICBkZWNsYXJhdGlvbnM6IFsgQmFzZUNoYXJ0RGlyZWN0aXZlIF0sXG4gIGV4cG9ydHM6IFsgQmFzZUNoYXJ0RGlyZWN0aXZlIF1cbn0pXG5leHBvcnQgY2xhc3MgTmdDaGFydHNNb2R1bGUge1xuXG4gIGNvbnN0cnVjdG9yKEBPcHRpb25hbCgpIGNvbmZpZz86IE5nQ2hhcnRzQ29uZmlndXJhdGlvbikge1xuICAgIGlmIChjb25maWc/LnBsdWdpbnMpXG4gICAgICBDaGFydC5yZWdpc3RlciguLi5jb25maWc/LnBsdWdpbnMpO1xuXG4gICAgY29uc3QgbmdDaGFydHNEZWZhdWx0cyA9IG1lcmdlKGJ1aWx0SW5EZWZhdWx0cywgY29uZmlnPy5kZWZhdWx0cyB8fCB7fSk7XG5cbiAgICBkZWZhdWx0cy5zZXQobmdDaGFydHNEZWZhdWx0cyk7XG4gIH1cblxuICBwdWJsaWMgc3RhdGljIGZvclJvb3QoY29uZmlnPzogTmdDaGFydHNDb25maWd1cmF0aW9uKTogTW9kdWxlV2l0aFByb3ZpZGVyczxOZ0NoYXJ0c01vZHVsZT4ge1xuICAgIHJldHVybiB7XG4gICAgICBuZ01vZHVsZTogTmdDaGFydHNNb2R1bGUsXG4gICAgICBwcm92aWRlcnM6IFtcbiAgICAgICAgeyBwcm92aWRlOiBOZ0NoYXJ0c0NvbmZpZ3VyYXRpb24sIHVzZVZhbHVlOiBjb25maWcgfVxuICAgICAgXVxuICAgIH07XG4gIH1cbn1cbiJdfQ==