import { Component, HostBinding, Input } from '@angular/core';
import * as i0 from "@angular/core";
export class SpinnerComponent {
    constructor() {
        /**
         * Label for accessibility.
         * @type string
         * @default 'Loading...'
         */
        this.label = "Loading...";
        /**
         * Set the button variant to an outlined button or a ghost button.
         * @values 'border' | 'grow'
         * @default 'border'
         */
        this.variant = 'border';
        this.role = 'status';
    }
    get hostClasses() {
        return {
            [`spinner-${this.variant}`]: true,
            [`text-${this.color}`]: !!this.color,
            [`spinner-${this.variant}-${this.size}`]: !!this.size
        };
    }
}
SpinnerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SpinnerComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
SpinnerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: SpinnerComponent, selector: "c-spinner", inputs: { color: "color", label: "label", size: "size", variant: "variant", role: "role" }, host: { properties: { "attr.role": "this.role", "class": "this.hostClasses" } }, ngImport: i0, template: "<span class=\"visually-hidden\">{{label}}</span>\n" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SpinnerComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-spinner', template: "<span class=\"visually-hidden\">{{label}}</span>\n" }]
        }], propDecorators: { color: [{
                type: Input
            }], label: [{
                type: Input
            }], size: [{
                type: Input
            }], variant: [{
                type: Input
            }], role: [{
                type: Input
            }, {
                type: HostBinding,
                args: ['attr.role']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3Bpbm5lci5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9jb3JldWktYW5ndWxhci9zcmMvbGliL3NwaW5uZXIvc3Bpbm5lci5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9jb3JldWktYW5ndWxhci9zcmMvbGliL3NwaW5uZXIvc3Bpbm5lci5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLFdBQVcsRUFBRSxLQUFLLEVBQUUsTUFBTSxlQUFlLENBQUM7O0FBUTlELE1BQU0sT0FBTyxnQkFBZ0I7SUFKN0I7UUFXRTs7OztXQUlHO1FBQ00sVUFBSyxHQUFXLFlBQVksQ0FBQztRQVN0Qzs7OztXQUlHO1FBQ00sWUFBTyxHQUF1QixRQUFRLENBQUM7UUFHdEIsU0FBSSxHQUFHLFFBQVEsQ0FBQztLQVUzQztJQVJDLElBQ0ksV0FBVztRQUNiLE9BQU87WUFDTCxDQUFDLFdBQVcsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLEVBQUUsSUFBSTtZQUNqQyxDQUFDLFFBQVEsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLO1lBQ3BDLENBQUMsV0FBVyxJQUFJLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSTtTQUN0RCxDQUFDO0lBQ0osQ0FBQzs7NkdBdENVLGdCQUFnQjtpR0FBaEIsZ0JBQWdCLDhOQ1I3QixvREFDQTsyRkRPYSxnQkFBZ0I7a0JBSjVCLFNBQVM7K0JBQ0UsV0FBVzs4QkFRWixLQUFLO3NCQUFiLEtBQUs7Z0JBT0csS0FBSztzQkFBYixLQUFLO2dCQU9HLElBQUk7c0JBQVosS0FBSztnQkFPRyxPQUFPO3NCQUFmLEtBQUs7Z0JBR29CLElBQUk7c0JBRDdCLEtBQUs7O3NCQUNMLFdBQVc7dUJBQUMsV0FBVztnQkFHcEIsV0FBVztzQkFEZCxXQUFXO3VCQUFDLE9BQU8iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIEhvc3RCaW5kaW5nLCBJbnB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5cclxuaW1wb3J0IHsgQ29sb3JzIH0gZnJvbSAnLi4vY29yZXVpLnR5cGVzJztcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiAnYy1zcGlubmVyJyxcclxuICB0ZW1wbGF0ZVVybDogJy4vc3Bpbm5lci5jb21wb25lbnQuaHRtbCcsXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTcGlubmVyQ29tcG9uZW50IHtcclxuICAvKipcclxuICAgKiBTZXRzIHRoZSBjb2xvciBjb250ZXh0IG9mIHRoZSBjb21wb25lbnQgdG8gb25lIG9mIENvcmVVSeKAmXMgdGhlbWVkIGNvbG9ycy5cclxuICAgKiBAdHlwZSBDb2xvcnNcclxuICAgKi9cclxuICBASW5wdXQoKSBjb2xvcj86IENvbG9ycztcclxuXHJcbiAgLyoqXHJcbiAgICogTGFiZWwgZm9yIGFjY2Vzc2liaWxpdHkuXHJcbiAgICogQHR5cGUgc3RyaW5nXHJcbiAgICogQGRlZmF1bHQgJ0xvYWRpbmcuLi4nXHJcbiAgICovXHJcbiAgQElucHV0KCkgbGFiZWw6IHN0cmluZyA9IFwiTG9hZGluZy4uLlwiO1xyXG5cclxuICAvKipcclxuICAgKiBTaXplIHRoZSBjb21wb25lbnQgc21hbGwuXHJcbiAgICogQHR5cGUgc3RyaW5nXHJcbiAgICogQHZhbHVlcyAnc20nXHJcbiAgICovXHJcbiAgQElucHV0KCkgc2l6ZT86ICdzbSc7XHJcblxyXG4gIC8qKlxyXG4gICAqIFNldCB0aGUgYnV0dG9uIHZhcmlhbnQgdG8gYW4gb3V0bGluZWQgYnV0dG9uIG9yIGEgZ2hvc3QgYnV0dG9uLlxyXG4gICAqIEB2YWx1ZXMgJ2JvcmRlcicgfCAnZ3JvdydcclxuICAgKiBAZGVmYXVsdCAnYm9yZGVyJ1xyXG4gICAqL1xyXG4gIEBJbnB1dCgpIHZhcmlhbnQ/OiAnYm9yZGVyJyB8ICdncm93JyA9ICdib3JkZXInO1xyXG5cclxuICBASW5wdXQoKVxyXG4gIEBIb3N0QmluZGluZygnYXR0ci5yb2xlJykgcm9sZSA9ICdzdGF0dXMnO1xyXG5cclxuICBASG9zdEJpbmRpbmcoJ2NsYXNzJylcclxuICBnZXQgaG9zdENsYXNzZXMoKTogYW55IHtcclxuICAgIHJldHVybiB7XHJcbiAgICAgIFtgc3Bpbm5lci0ke3RoaXMudmFyaWFudH1gXTogdHJ1ZSxcclxuICAgICAgW2B0ZXh0LSR7dGhpcy5jb2xvcn1gXTogISF0aGlzLmNvbG9yLFxyXG4gICAgICBbYHNwaW5uZXItJHt0aGlzLnZhcmlhbnR9LSR7dGhpcy5zaXplfWBdOiAhIXRoaXMuc2l6ZVxyXG4gICAgfTtcclxuICB9XHJcbn1cclxuIiwiPHNwYW4gY2xhc3M9XCJ2aXN1YWxseS1oaWRkZW5cIj57e2xhYmVsfX08L3NwYW4+XG4iXX0=