import { Component, EventEmitter, HostBinding, Inject, Input, Output } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
import * as i1 from "@angular/cdk/layout";
import * as i2 from "../sidebar.service";
import * as i3 from "../sidebar-backdrop/sidebar-backdrop.service";
export class SidebarComponent {
    constructor(document, renderer, breakpointObserver, sidebarService, backdropService) {
        this.document = document;
        this.renderer = renderer;
        this.breakpointObserver = breakpointObserver;
        this.sidebarService = sidebarService;
        this.backdropService = backdropService;
        this._narrow = false;
        this._overlaid = false;
        this._unfoldable = false;
        this._visible = false;
        this.onMobile = false;
        this.state = {
            sidebar: this
        };
        /**
         * Place sidebar in non-static positions. [docs]
         * @default 'fixed'
         */
        this.position = 'fixed';
        /**
         * Event emitted on visibility change. [docs]
         * @type boolean
         */
        this.visibleChange = new EventEmitter();
        this.backdropService.renderer = renderer;
    }
    /**
     * Make sidebar narrow. [docs]
     * @type boolean
     */
    set narrow(value) {
        this._narrow = coerceBooleanProperty(value);
    }
    get narrow() {
        return this._narrow;
    }
    /**
     * Set sidebar to overlaid variant.
     * @type boolean
     */
    set overlaid(value) {
        this._overlaid = coerceBooleanProperty(value);
    }
    get overlaid() {
        return this._overlaid;
    }
    /**
     * Expand narrowed sidebar on hover. [docs]
     */
    set unfoldable(value) {
        this._unfoldable = coerceBooleanProperty(value);
    }
    get unfoldable() {
        return this._unfoldable;
    }
    /**
     * Toggle the visibility of sidebar component. [docs]
     */
    set visible(value) {
        this._visible = coerceBooleanProperty(value);
        this.visibleChange.emit(this._visible);
    }
    get visible() {
        return this._visible;
    }
    set sidebarState(value) {
        const newState = value;
        if ('toggle' in newState) {
            if (newState.toggle === 'visible') {
                newState.visible = !this.state.visible;
                this.visible = newState.visible && !this.overlaid;
            }
            else if (newState.toggle === 'unfoldable') {
                newState.unfoldable = !this.state.unfoldable;
                this.unfoldable = newState.unfoldable;
            }
        }
        this.state = {
            ...this.state,
            ...newState
        };
        this.state.mobile && this.state.visible ? this.backdropService.setBackdrop(this) : this.backdropService.clearBackdrop();
    }
    get sidebarState() {
        return this.state;
    }
    get getMobileBreakpoint() {
        const element = this.document.firstElementChild;
        const mobileBreakpoint = getComputedStyle(element).getPropertyValue('--cui-mobile-breakpoint') || 'md';
        const breakpointValue = getComputedStyle(element).getPropertyValue(`--cui-breakpoint-${mobileBreakpoint.trim()}`) || '768px';
        return `${parseFloat(breakpointValue.trim()) - .02}px` || '767.98px';
    }
    get getClasses() {
        const { mobile, unfoldable, visible } = this.sidebarState;
        return {
            sidebar: true,
            'sidebar-fixed': this.position === 'fixed' && !mobile,
            'sidebar-narrow': this.narrow && !this.unfoldable,
            'sidebar-narrow-unfoldable': unfoldable,
            'sidebar-overlaid': this.overlaid,
            [`sidebar-${this.size}`]: !!this.size,
            show: visible && this.onMobile,
            hide: !visible && !this.onMobile
        };
    }
    ngOnInit() {
        this.setInitialState();
        this.layoutChangeSubscribe();
        this.stateToggleSubscribe();
    }
    ngOnDestroy() {
        this.stateToggleSubscribe(false);
        this.layoutChangeSubscribe(false);
    }
    ngOnChanges(changes) {
        const oldStateMap = new Map(Object.entries(this.state));
        const newStateMap = new Map();
        newStateMap.set('sidebar', this);
        const propList = ['visible', 'unfoldable', 'narrow'];
        for (const propName in changes) {
            if (propList.includes(propName)) {
                if (changes[propName] && !changes[propName].firstChange) {
                    const value = coerceBooleanProperty(changes[propName].currentValue);
                    if (oldStateMap.get(propName) !== value) {
                        newStateMap.set(propName, value);
                    }
                }
            }
        }
        if (newStateMap.size > 1) {
            const state = Object.fromEntries(newStateMap.entries());
            this.sidebarService.toggle(state);
        }
    }
    setInitialState() {
        this.sidebarService.toggle({
            narrow: this.narrow,
            visible: this.visible,
            unfoldable: this.unfoldable,
            sidebar: this
        });
    }
    stateToggleSubscribe(subscribe = true) {
        if (subscribe) {
            this.stateToggleSubscription = this.sidebarService.sidebarState$.subscribe((state) => {
                if (this === state.sidebar || this.id === state.id) {
                    this.sidebarState = state;
                }
            });
        }
        else {
            this.stateToggleSubscription.unsubscribe();
        }
    }
    layoutChangeSubscribe(subscribe = true) {
        const onMobile = `(max-width: ${this.getMobileBreakpoint})`;
        if (subscribe) {
            const layoutChanges = this.breakpointObserver.observe([onMobile]);
            this.layoutChangeSubscription = layoutChanges.subscribe((result) => {
                const isOnMobile = result.breakpoints[onMobile];
                if (this.onMobile !== isOnMobile) {
                    this.onMobile = isOnMobile;
                    this.sidebarService.toggle({
                        mobile: isOnMobile,
                        unfoldable: isOnMobile ? false : this.unfoldable,
                        visible: isOnMobile ? false : this.visible,
                        sidebar: this
                    });
                }
            });
        }
        else {
            this.layoutChangeSubscription.unsubscribe();
        }
    }
}
SidebarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarComponent, deps: [{ token: DOCUMENT }, { token: i0.Renderer2 }, { token: i1.BreakpointObserver }, { token: i2.SidebarService }, { token: i3.SidebarBackdropService }], target: i0.ɵɵFactoryTarget.Component });
SidebarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: SidebarComponent, selector: "c-sidebar", inputs: { id: "id", narrow: "narrow", overlaid: "overlaid", position: "position", size: "size", unfoldable: "unfoldable", visible: "visible" }, outputs: { visibleChange: "visibleChange" }, host: { properties: { "class": "this.getClasses" } }, exportAs: ["cSidebar"], usesOnChanges: true, ngImport: i0, template: '<ng-content></ng-content>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-sidebar',
                    exportAs: 'cSidebar',
                    template: '<ng-content></ng-content>',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: i0.Renderer2 }, { type: i1.BreakpointObserver }, { type: i2.SidebarService }, { type: i3.SidebarBackdropService }]; }, propDecorators: { id: [{
                type: Input
            }], narrow: [{
                type: Input
            }], overlaid: [{
                type: Input
            }], position: [{
                type: Input
            }], size: [{
                type: Input
            }], unfoldable: [{
                type: Input
            }], visible: [{
                type: Input
            }], visibleChange: [{
                type: Output
            }], getClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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