import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export class SidebarNavService {
}
SidebarNavService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
SidebarNavService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavService, decorators: [{
            type: Injectable
        }] });
export class SidebarNavHelper {
    constructor() {
        this.hasBadge = (item) => Boolean(item.badge);
        this.hasIcon = (item) => Boolean(item.icon) || item.icon === '';
        this.hasIconComponent = (item) => Boolean(item.iconComponent);
    }
    itemType(item) {
        if (item.divider) {
            return 'divider';
        }
        else if (item.title) {
            return 'title';
        }
        else if (item.children && item.children.length > 0) {
            return 'group';
        }
        else if (item.label) {
            return 'label';
        }
        else if (!Object.keys(item).length) {
            return 'empty';
        }
        else {
            return 'link';
        }
    }
    isActive(router, item) {
        return router.isActive(item.url, false);
    }
    getIconClass(item) {
        const classes = {
            'nav-icon': true
        };
        const icon = item.icon;
        // @ts-ignore
        classes[icon] = this.hasIcon(item);
        return classes;
    }
}
SidebarNavHelper.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavHelper, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
SidebarNavHelper.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavHelper });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavHelper, decorators: [{
            type: Injectable
        }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2lkZWJhci1uYXYuc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL2NvcmV1aS1hbmd1bGFyL3NyYy9saWIvc2lkZWJhci9zaWRlYmFyLW5hdi9zaWRlYmFyLW5hdi5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7O0FBSzNDLE1BQU0sT0FBZ0IsaUJBQWlCOzs4R0FBakIsaUJBQWlCO2tIQUFqQixpQkFBaUI7MkZBQWpCLGlCQUFpQjtrQkFEdEMsVUFBVTs7QUFTWCxNQUFNLE9BQU8sZ0JBQWdCO0lBRDdCO1FBdUJTLGFBQVEsR0FBRyxDQUFDLElBQWMsRUFBRSxFQUFFLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNuRCxZQUFPLEdBQUcsQ0FBQyxJQUFjLEVBQUUsRUFBRSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxFQUFFLENBQUM7UUFDckUscUJBQWdCLEdBQUcsQ0FBQyxJQUFjLEVBQUUsRUFBRSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FXM0U7SUFqQ0MsUUFBUSxDQUFDLElBQWM7UUFDckIsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2hCLE9BQU8sU0FBUyxDQUFDO1NBQ2xCO2FBQU0sSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ3JCLE9BQU8sT0FBTyxDQUFDO1NBQ2hCO2FBQU0sSUFBSSxJQUFJLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRztZQUNyRCxPQUFPLE9BQU8sQ0FBQztTQUNoQjthQUFNLElBQUksSUFBSSxDQUFDLEtBQUssRUFBRTtZQUNyQixPQUFPLE9BQU8sQ0FBQztTQUNoQjthQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sRUFBRTtZQUNwQyxPQUFPLE9BQU8sQ0FBQztTQUNoQjthQUFNO1lBQ0wsT0FBTyxNQUFNLENBQUM7U0FDZjtJQUNILENBQUM7SUFFTSxRQUFRLENBQUMsTUFBVyxFQUFFLElBQWM7UUFDekMsT0FBTyxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDMUMsQ0FBQztJQU1NLFlBQVksQ0FBQyxJQUFjO1FBQ2hDLE1BQU0sT0FBTyxHQUFHO1lBQ2QsVUFBVSxFQUFFLElBQUk7U0FDakIsQ0FBQztRQUNGLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUM7UUFDdkIsYUFBYTtRQUNiLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ25DLE9BQU8sT0FBTyxDQUFDO0lBQ2pCLENBQUM7OzZHQWxDVSxnQkFBZ0I7aUhBQWhCLGdCQUFnQjsyRkFBaEIsZ0JBQWdCO2tCQUQ1QixVQUFVIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5cclxuaW1wb3J0IHsgSU5hdkRhdGEgfSBmcm9tICcuL3NpZGViYXItbmF2JztcclxuXHJcbkBJbmplY3RhYmxlKClcclxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIFNpZGViYXJOYXZTZXJ2aWNlIHtcclxuICAvKipcclxuICAgKiBSZXR1cm5zIGEgc2lkZWJhci1uYXYgaXRlbXMgY29uZmlnIE5hdkRhdGFcclxuICAgKi9cclxuICBhYnN0cmFjdCBnZXRTaWRlYmFyTmF2SXRlbXNDb25maWcoKTogSU5hdkRhdGFbXTtcclxufVxyXG5cclxuQEluamVjdGFibGUoKVxyXG5leHBvcnQgY2xhc3MgU2lkZWJhck5hdkhlbHBlciB7XHJcblxyXG4gIGl0ZW1UeXBlKGl0ZW06IElOYXZEYXRhKTogc3RyaW5nIHtcclxuICAgIGlmIChpdGVtLmRpdmlkZXIpIHtcclxuICAgICAgcmV0dXJuICdkaXZpZGVyJztcclxuICAgIH0gZWxzZSBpZiAoaXRlbS50aXRsZSkge1xyXG4gICAgICByZXR1cm4gJ3RpdGxlJztcclxuICAgIH0gZWxzZSBpZiAoaXRlbS5jaGlsZHJlbiAmJiBpdGVtLmNoaWxkcmVuLmxlbmd0aCA+IDAgKSB7XHJcbiAgICAgIHJldHVybiAnZ3JvdXAnO1xyXG4gICAgfSBlbHNlIGlmIChpdGVtLmxhYmVsKSB7XHJcbiAgICAgIHJldHVybiAnbGFiZWwnO1xyXG4gICAgfSBlbHNlIGlmICghT2JqZWN0LmtleXMoaXRlbSkubGVuZ3RoKSB7XHJcbiAgICAgIHJldHVybiAnZW1wdHknO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuICdsaW5rJztcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBpc0FjdGl2ZShyb3V0ZXI6IGFueSwgaXRlbTogSU5hdkRhdGEpOiBib29sZWFuIHtcclxuICAgIHJldHVybiByb3V0ZXIuaXNBY3RpdmUoaXRlbS51cmwsIGZhbHNlKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBoYXNCYWRnZSA9IChpdGVtOiBJTmF2RGF0YSkgPT4gQm9vbGVhbihpdGVtLmJhZGdlKTtcclxuICBwdWJsaWMgaGFzSWNvbiA9IChpdGVtOiBJTmF2RGF0YSkgPT4gQm9vbGVhbihpdGVtLmljb24pIHx8IGl0ZW0uaWNvbiA9PT0gJyc7XHJcbiAgcHVibGljIGhhc0ljb25Db21wb25lbnQgPSAoaXRlbTogSU5hdkRhdGEpID0+IEJvb2xlYW4oaXRlbS5pY29uQ29tcG9uZW50KTtcclxuXHJcbiAgcHVibGljIGdldEljb25DbGFzcyhpdGVtOiBJTmF2RGF0YSk6IGFueSB7XHJcbiAgICBjb25zdCBjbGFzc2VzID0ge1xyXG4gICAgICAnbmF2LWljb24nOiB0cnVlXHJcbiAgICB9O1xyXG4gICAgY29uc3QgaWNvbiA9IGl0ZW0uaWNvbjtcclxuICAgIC8vIEB0cy1pZ25vcmVcclxuICAgIGNsYXNzZXNbaWNvbl0gPSB0aGlzLmhhc0ljb24oaXRlbSk7XHJcbiAgICByZXR1cm4gY2xhc3NlcztcclxuICB9XHJcbn1cclxuIl19