import { Pipe } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./sidebar-nav.service";
export class SidebarNavItemClassPipe {
    constructor(helper) {
        this.helper = helper;
    }
    // transform(item: any, ...args: any[]): any {
    transform(item, args) {
        const itemType = this.helper.itemType(item);
        let itemClass;
        if (['divider', 'title'].includes(itemType)) {
            itemClass = `nav-${itemType}`;
        }
        else if (itemType === 'group') {
            // itemClass = 'c-sidebar-nav-group' ;
            itemClass = '';
        }
        else {
            itemClass = 'nav-item';
        }
        return item.class ? `${itemClass} ${item.class}` : itemClass;
    }
}
SidebarNavItemClassPipe.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavItemClassPipe, deps: [{ token: i1.SidebarNavHelper }], target: i0.ɵɵFactoryTarget.Pipe });
SidebarNavItemClassPipe.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "14.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavItemClassPipe, name: "cSidebarNavItemClass" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavItemClassPipe, decorators: [{
            type: Pipe,
            args: [{
                    name: 'cSidebarNavItemClass'
                }]
        }], ctorParameters: function () { return [{ type: i1.SidebarNavHelper }]; } });
//# sourceMappingURL=data:application/json;base64,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