import { Component, ContentChild, HostBinding, Input } from '@angular/core';
import { CollapseDirective } from '../collapse';
import * as i0 from "@angular/core";
import * as i1 from "@angular/cdk/layout";
import * as i2 from "@angular/common";
// todo: fix container prop issue not rendering children
// todo: workaroud -  use <c-container> component directly in template
export class NavbarComponent {
    constructor(hostElement, breakpointObserver) {
        this.hostElement = hostElement;
        this.breakpointObserver = breakpointObserver;
        /**
         * Sets if the color of text should be colored for a light or dark dark background.
         */
        this.colorScheme = 'light';
        this.role = 'navigation';
    }
    get hostClasses() {
        const expandClassSuffix = this.expand === true ? '' : `-${this.expand}`;
        return {
            navbar: true,
            'navbar-light': this.colorScheme === 'light',
            'navbar-dark': this.colorScheme === 'dark',
            [`navbar-expand${expandClassSuffix}`]: !!this.expand,
            [`bg-${this.color}`]: !!this.color,
            [`${this.placement}`]: !!this.placement
        };
    }
    get containerClass() {
        return `container${this.container !== true ? '-' + this.container : ''}`;
    }
    get breakpoint() {
        if (typeof this.expand === 'string') {
            return getComputedStyle(this.hostElement.nativeElement).getPropertyValue(`--cui-breakpoint-${this.expand}`);
        }
        return false;
    }
    ngAfterContentInit() {
        if (this.breakpoint) {
            const onBreakpoint = `(min-width: ${this.breakpoint})`;
            this.breakpointObserver.observe([onBreakpoint]).subscribe(result => {
                if (this.collapse) {
                    const animate = this.collapse.animate;
                    this.collapse.toggle(false);
                    this.collapse.animate = false;
                    setTimeout(() => {
                        this.collapse.toggle(result.matches);
                        setTimeout(() => {
                            this.collapse.animate = animate;
                        });
                    });
                }
            });
        }
    }
}
NavbarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NavbarComponent, deps: [{ token: i0.ElementRef }, { token: i1.BreakpointObserver }], target: i0.ɵɵFactoryTarget.Component });
NavbarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: NavbarComponent, selector: "c-navbar", inputs: { color: "color", colorScheme: "colorScheme", container: "container", expand: "expand", placement: "placement", role: "role" }, host: { properties: { "attr.role": "this.role", "class": "this.hostClasses" } }, queries: [{ propertyName: "collapse", first: true, predicate: CollapseDirective, descendants: true }], ngImport: i0, template: "<ng-container *ngTemplateOutlet=\"container ? withContainerTemplate : noContainerTemplate\"></ng-container>\n\n<ng-template #withContainerTemplate>\n  <div [ngClass]=\"containerClass\">\n    <ng-content></ng-content>\n  </div>\n</ng-template>\n\n<ng-template #noContainerTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", styles: [""], dependencies: [{ kind: "directive", type: i2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i2.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NavbarComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-navbar', template: "<ng-container *ngTemplateOutlet=\"container ? withContainerTemplate : noContainerTemplate\"></ng-container>\n\n<ng-template #withContainerTemplate>\n  <div [ngClass]=\"containerClass\">\n    <ng-content></ng-content>\n  </div>\n</ng-template>\n\n<ng-template #noContainerTemplate>\n  <ng-content></ng-content>\n</ng-template>\n" }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i1.BreakpointObserver }]; }, propDecorators: { color: [{
                type: Input
            }], colorScheme: [{
                type: Input
            }], container: [{
                type: Input
            }], expand: [{
                type: Input
            }], placement: [{
                type: Input
            }], collapse: [{
                type: ContentChild,
                args: [CollapseDirective]
            }], role: [{
                type: HostBinding,
                args: ['attr.role']
            }, {
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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