import { Component, ContentChild, Directive, EventEmitter, forwardRef, HostBinding, HostListener, Inject, Input, Optional, Output } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { createPopper } from '@popperjs/core';
import { DropdownService } from '../dropdown.service';
import { DropdownMenuDirective } from '../dropdown-menu/dropdown-menu.directive';
import * as i0 from "@angular/core";
import * as i1 from "../dropdown.service";
// lightweight injection token
export class DropdownToken {
}
export class DropdownToggleDirective {
    constructor(elementRef, dropdownService, dropdown) {
        this.elementRef = elementRef;
        this.dropdownService = dropdownService;
        this.dropdown = dropdown;
        /**
         * Disables the toggler.
         * @type boolean
         * @default false
         */
        this.disabled = false;
        /**
         * Enables pseudo element caret on toggler.
         * @type boolean
         */
        this.caret = true;
        this._split = false;
    }
    /**
     * Create split button dropdowns with virtually the same markup as single button dropdowns, but with the addition of `.dropdown-toggle-split` class for proper spacing around the dropdown caret.
     * @type boolean
     */
    set split(value) {
        this._split = coerceBooleanProperty(value);
    }
    get split() {
        return this._split;
    }
    get hostClasses() {
        return {
            'dropdown-toggle': this.caret,
            'dropdown-toggle-split': this.split,
            disabled: this.disabled
        };
    }
    onClick($event) {
        $event.preventDefault();
        !this.disabled && this.dropdownService.toggle({ visible: 'toggle', dropdown: this.dropdown });
    }
    ngAfterViewInit() {
        if (this.dropdownComponent) {
            this.dropdown = this.dropdownComponent;
            this.dropdownService = this.dropdownComponent?.dropdownService;
        }
    }
}
DropdownToggleDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: DropdownToggleDirective, deps: [{ token: i0.ElementRef }, { token: i1.DropdownService }, { token: DropdownToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
DropdownToggleDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: DropdownToggleDirective, selector: "[cDropdownToggle]", inputs: { dropdownComponent: "dropdownComponent", disabled: "disabled", caret: "caret", split: "split" }, host: { listeners: { "click": "onClick($event)" }, properties: { "class": "this.hostClasses" } }, providers: [{ provide: DropdownToken, useExisting: forwardRef(() => DropdownComponent) }], exportAs: ["cDropdownToggle"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: DropdownToggleDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cDropdownToggle]',
                    providers: [{ provide: DropdownToken, useExisting: forwardRef(() => DropdownComponent) }],
                    exportAs: 'cDropdownToggle'
                }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i1.DropdownService }, { type: DropdownToken, decorators: [{
                    type: Optional
                }] }]; }, propDecorators: { dropdownComponent: [{
                type: Input
            }], disabled: [{
                type: Input
            }], caret: [{
                type: Input
            }], split: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], onClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }] } });
export class DropdownComponent {
    constructor(document, elementRef, renderer, ngZone, changeDetectorRef, dropdownService) {
        this.document = document;
        this.elementRef = elementRef;
        this.renderer = renderer;
        this.ngZone = ngZone;
        this.changeDetectorRef = changeDetectorRef;
        this.dropdownService = dropdownService;
        this.autoClose = true;
        this._dark = false;
        /**
         * Describes the placement of your component after Popper.js has applied all the modifiers that may have flipped or altered the originally provided placement property.
         * @type Placement
         */
        this.placement = 'bottom-start';
        this._popper = true;
        this._popperOptions = {
            placement: this.placement,
            modifiers: [],
            strategy: 'absolute'
        };
        /**
         * Set the dropdown variant to an btn-group, dropdown, input-group, and nav-item.
         */
        this.variant = 'dropdown';
        this._visible = false;
        this.visibleChange = new EventEmitter();
        this.dropdownContext = { $implicit: this.visible };
        this.activeTrap = false;
        this.listeners = [];
    }
    /**
     * Sets a darker color scheme to match a dark navbar.
     * @type boolean
     * @default false
     */
    set dark(value) {
        this._dark = coerceBooleanProperty(value);
    }
    ;
    get dark() {
        return this._dark;
    }
    /**
     * If you want to disable dynamic positioning set this property to `false`.
     * @type boolean
     * @default true
     */
    set popper(value) {
        this._popper = coerceBooleanProperty(value);
    }
    get popper() {
        return this._popper;
    }
    /**
     * Optional popper Options object, placement prop takes precedence over
     * @type Partial<Options>
     */
    set popperOptions(value) {
        this._popperOptions = { ...this._popperOptions, ...value };
    }
    ;
    get popperOptions() {
        let placement = this.placement;
        switch (this.direction) {
            case 'dropup': {
                placement = 'top-start';
                break;
            }
            case 'dropend': {
                placement = 'right-start';
                break;
            }
            case 'dropstart': {
                placement = 'left-start';
                break;
            }
        }
        if (this.alignment === 'end') {
            placement = 'bottom-end';
        }
        this._popperOptions = { ...this._popperOptions, placement: placement };
        return this._popperOptions;
    }
    /**
     * Toggle the visibility of dropdown menu component.
     * @type boolean
     * @default false
     */
    set visible(value) {
        const _value = coerceBooleanProperty(value);
        this.activeTrap = _value;
        this._visible = _value;
        _value ? this.createPopperInstance() : this.destroyPopperInstance();
        this.visibleChange.emit(_value);
    }
    get visible() {
        return this._visible;
    }
    get hostClasses() {
        return {
            dropdown: (this.variant === 'dropdown' || this.variant === 'nav-item') &&
                !this.direction,
            [`${this.direction}`]: !!this.direction,
            'btn-group': this.variant === 'btn-group',
            'nav-item': this.variant === 'nav-item',
            'input-group': this.variant === 'input-group',
            show: this.visible
        };
    }
    // todo: find better solution
    get hostStyle() {
        return this.variant === 'input-group' ? { display: 'contents' } : {};
    }
    onHostClick($event) {
        this.clickedTarget = $event.target;
    }
    dropdownStateSubscribe(subscribe = true) {
        if (subscribe) {
            this.dropdownStateSubscription =
                this.dropdownService.dropdownState$.subscribe((state) => {
                    if (this === state.dropdown) {
                        if ('visible' in state) {
                            state?.visible === 'toggle'
                                ? this.toggleDropdown()
                                : (this.visible = state.visible);
                        }
                    }
                });
        }
        else {
            this.dropdownStateSubscription.unsubscribe();
        }
    }
    toggleDropdown() {
        this.visible = !this.visible;
    }
    onClick(event) {
        if (!this._toggler?.elementRef.nativeElement.contains(event.target?.closest('[cDropdownToggle]'))) {
            this.toggleDropdown();
        }
    }
    ngAfterContentInit() {
        if (this.variant === 'nav-item') {
            this.renderer.addClass(this._toggler.elementRef.nativeElement, 'nav-link');
        }
    }
    ngOnInit() {
        this.dropdownStateSubscribe();
        this.setVisibleState(this.visible);
    }
    ngOnDestroy() {
        this.clearListeners();
        this.dropdownStateSubscribe(false);
        this.destroyPopperInstance();
    }
    setVisibleState(value) {
        this.dropdownService.toggle({ visible: value, dropdown: this });
    }
    // todo: turn off popper in navbar-nav
    createPopperInstance() {
        if (this._toggler && this._menu) {
            this.ngZone.runOutsideAngular(() => {
                // workaround for popper position calculate (see also: dropdown-menu.component)
                this._menu.elementRef.nativeElement.style.visibility = 'hidden';
                this._menu.elementRef.nativeElement.style.display = 'block';
                if (this.popper) {
                    this.popperInstance = createPopper(this._toggler.elementRef.nativeElement, this._menu.elementRef.nativeElement, { ...this.popperOptions });
                }
                this.ngZone.run(() => {
                    this.setListeners();
                    this.changeDetectorRef.detectChanges();
                });
            });
        }
    }
    destroyPopperInstance() {
        this.clearListeners();
        this.popperInstance?.destroy();
        this.popperInstance = undefined;
        this.changeDetectorRef.markForCheck();
    }
    setListeners() {
        this.listeners.push(this.renderer.listen(this.document, 'click', (event) => {
            const target = event.target;
            if (this._toggler?.elementRef.nativeElement.contains(event.target)) {
                return;
            }
            if (this.autoClose === true) {
                this.setVisibleState(false);
                return;
            }
            if (this.clickedTarget === target && this.autoClose === 'inside') {
                this.setVisibleState(false);
                return;
            }
            if (this.clickedTarget !== target && this.autoClose === 'outside') {
                this.setVisibleState(false);
                return;
            }
        }));
        this.listeners.push(this.renderer.listen(this.document, 'keyup', (event) => {
            if (event.key === 'Escape' && this.autoClose !== false) {
                this.setVisibleState(false);
            }
        }));
    }
    clearListeners() {
        this.listeners.forEach((unListen) => {
            unListen();
        });
        // @ts-ignore
        this.listeners.fill(undefined);
        this.listeners = [];
    }
}
DropdownComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: DropdownComponent, deps: [{ token: DOCUMENT }, { token: i0.ElementRef }, { token: i0.Renderer2 }, { token: i0.NgZone }, { token: i0.ChangeDetectorRef }, { token: i1.DropdownService }], target: i0.ɵɵFactoryTarget.Component });
DropdownComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: DropdownComponent, selector: "c-dropdown", inputs: { alignment: "alignment", autoClose: "autoClose", dark: "dark", direction: "direction", placement: "placement", popper: "popper", popperOptions: "popperOptions", variant: "variant", visible: "visible" }, outputs: { visibleChange: "visibleChange" }, host: { listeners: { "click": "onHostClick($event)" }, properties: { "class": "this.hostClasses", "style": "this.hostStyle" } }, providers: [DropdownService], queries: [{ propertyName: "_toggler", first: true, predicate: DropdownToggleDirective, descendants: true }, { propertyName: "_menu", first: true, predicate: DropdownMenuDirective, descendants: true }], exportAs: ["cDropdown"], ngImport: i0, template: '<ng-content></ng-content>', isInline: true, styles: [":host-context(.dropdown,.dropup):not(.btn-group){display:block}:host-context(.dropstart,.dropend):not(.btn-group){display:inline-flex}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:first-child::ng-deep :first-child{border-top-right-radius:0;border-bottom-right-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-left:-1px;border-top-left-radius:0;border-bottom-left-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu):not(:only-of-type){border-top-right-radius:0;border-bottom-right-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:last-child::ng-deep :first-child{border-top-left-radius:0;border-bottom-left-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:last-child::ng-deep :first-child:not(:only-of-type){border-top-right-radius:0;border-bottom-right-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:last-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-left:-1px;border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host{direction:rtl}:host-context([dir=rtl] .input-group) :host:first-child::ng-deep :first-child{border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-right:-1px;border-top-right-radius:0;border-bottom-right-radius:0}:host-context([dir=rtl] .input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu):not(:only-of-type){border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host:last-child::ng-deep :first-child{border-top-right-radius:0;border-bottom-right-radius:0}:host-context([dir=rtl] .input-group) :host:last-child::ng-deep :first-child:not(:only-of-type){border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host:last-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-right:-1px;border-top-right-radius:0;border-bottom-right-radius:0}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: DropdownComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-dropdown', template: '<ng-content></ng-content>', exportAs: 'cDropdown', providers: [DropdownService], styles: [":host-context(.dropdown,.dropup):not(.btn-group){display:block}:host-context(.dropstart,.dropend):not(.btn-group){display:inline-flex}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:first-child::ng-deep :first-child{border-top-right-radius:0;border-bottom-right-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-left:-1px;border-top-left-radius:0;border-bottom-left-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu):not(:only-of-type){border-top-right-radius:0;border-bottom-right-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:last-child::ng-deep :first-child{border-top-left-radius:0;border-bottom-left-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:last-child::ng-deep :first-child:not(:only-of-type){border-top-right-radius:0;border-bottom-right-radius:0}:host-context(html:not([dir=rtl])) :host-context(.input-group) :host:last-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-left:-1px;border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host{direction:rtl}:host-context([dir=rtl] .input-group) :host:first-child::ng-deep :first-child{border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-right:-1px;border-top-right-radius:0;border-bottom-right-radius:0}:host-context([dir=rtl] .input-group) :host:first-child::ng-deep :not(:first-child):not(.dropdown-menu):not(:only-of-type){border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host:last-child::ng-deep :first-child{border-top-right-radius:0;border-bottom-right-radius:0}:host-context([dir=rtl] .input-group) :host:last-child::ng-deep :first-child:not(:only-of-type){border-top-left-radius:0;border-bottom-left-radius:0}:host-context([dir=rtl] .input-group) :host:last-child::ng-deep :not(:first-child):not(.dropdown-menu){margin-right:-1px;border-top-right-radius:0;border-bottom-right-radius:0}\n"] }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i0.NgZone }, { type: i0.ChangeDetectorRef }, { type: i1.DropdownService }]; }, propDecorators: { alignment: [{
                type: Input
            }], autoClose: [{
                type: Input
            }], dark: [{
                type: Input
            }], direction: [{
                type: Input
            }], placement: [{
                type: Input
            }], popper: [{
                type: Input
            }], popperOptions: [{
                type: Input
            }], variant: [{
                type: Input
            }], visible: [{
                type: Input
            }], visibleChange: [{
                type: Output
            }], _toggler: [{
                type: ContentChild,
                args: [DropdownToggleDirective]
            }], _menu: [{
                type: ContentChild,
                args: [DropdownMenuDirective]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], hostStyle: [{
                type: HostBinding,
                args: ['style']
            }], onHostClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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