import { Component, HostBinding, Input } from '@angular/core';
import * as i0 from "@angular/core";
export class ButtonGroupComponent {
    constructor() {
        /**
         * Default role attr for ButtonGroup. [docs]
         * @type string
         * @default 'group'
         */
        this.role = 'group';
    }
    get hostClasses() {
        return {
            'btn-group': !this.vertical,
            'btn-group-vertical': this.vertical,
            [`btn-group-${this.size}`]: !!this.size,
        };
    }
}
ButtonGroupComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ButtonGroupComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
ButtonGroupComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: ButtonGroupComponent, selector: "c-button-group", inputs: { size: "size", vertical: "vertical", role: "role" }, host: { properties: { "attr.role": "this.role", "class": "this.hostClasses" } }, ngImport: i0, template: `<ng-content></ng-content>`, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ButtonGroupComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-button-group',
                    template: `<ng-content></ng-content>`,
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { size: [{
                type: Input
            }], vertical: [{
                type: Input
            }], role: [{
                type: HostBinding,
                args: ['attr.role']
            }, {
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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