import { Directive, HostBinding, Input } from '@angular/core';
import * as i0 from "@angular/core";
export class AccordionButtonDirective {
    constructor() {
        /**
        * Default type for cAccordionButton. [docs]
         * @type string
         * @default 'button'
         */
        this.type = 'button';
    }
    get hostClasses() {
        return {
            'accordion-button': true,
            collapsed: this.collapsed
        };
    }
    get ariaExpanded() {
        return !this.collapsed;
    }
}
AccordionButtonDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionButtonDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
AccordionButtonDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: AccordionButtonDirective, selector: "[cAccordionButton]", inputs: { collapsed: "collapsed", type: "type" }, host: { properties: { "attr.type": "this.type", "class": "this.hostClasses", "attr.aria-expanded": "this.ariaExpanded" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionButtonDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cAccordionButton]'
                }]
        }], propDecorators: { collapsed: [{
                type: Input
            }], type: [{
                type: HostBinding,
                args: ['attr.type']
            }, {
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], ariaExpanded: [{
                type: HostBinding,
                args: ['attr.aria-expanded']
            }] } });
//# sourceMappingURL=data:application/json;base64,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