/// <amd-module name="@angular/compiler-cli/ngcc/src/rendering/commonjs_rendering_formatter" />
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import MagicString from 'magic-string';
import ts from 'typescript';
import { PathManipulation } from '../../../src/ngtsc/file_system';
import { Reexport } from '../../../src/ngtsc/imports';
import { Import, ImportManager } from '../../../src/ngtsc/translator';
import { ExportInfo } from '../analysis/private_declarations_analyzer';
import { NgccReflectionHost } from '../host/ngcc_host';
import { Esm5RenderingFormatter } from './esm5_rendering_formatter';
/**
 * A RenderingFormatter that works with CommonJS files, instead of `import` and `export` statements
 * the module is an IIFE with a factory function call with dependencies, which are defined in a
 * wrapper function for AMD, CommonJS and global module formats.
 */
export declare class CommonJsRenderingFormatter extends Esm5RenderingFormatter {
    protected commonJsHost: NgccReflectionHost;
    constructor(fs: PathManipulation, commonJsHost: NgccReflectionHost, isCore: boolean);
    /**
     *  Add the imports below any in situ imports as `require` calls.
     */
    addImports(output: MagicString, imports: Import[], file: ts.SourceFile): void;
    /**
     * Add the exports to the bottom of the file.
     */
    addExports(output: MagicString, entryPointBasePath: string, exports: ExportInfo[], importManager: ImportManager, file: ts.SourceFile): void;
    addDirectExports(output: MagicString, exports: Reexport[], importManager: ImportManager, file: ts.SourceFile): void;
    protected findEndOfImports(sf: ts.SourceFile): number;
}
