/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Directive, HostListener, Input } from '@angular/core';
var NgxPrintDirective = /** @class */ (function () {
    function NgxPrintDirective() {
        this._printStyle = [];
        /**
         *
         *
         * \@memberof NgxPrintDirective
         */
        this.useExistingCss = false;
        /**
         * A delay in milliseconds to force the print dialog to wait before opened. Default: 0
         *
         * \@memberof NgxPrintDirective
         */
        this.printDelay = 0;
        /**
         *
         *
         * @return html for the given tag
         *
         * \@memberof NgxPrintDirective
         */
        this._styleSheetFile = '';
    }
    Object.defineProperty(NgxPrintDirective.prototype, "printStyle", {
        /**
         *
         *
         * @memberof NgxPrintDirective
         */
        set: /**
         *
         *
         * \@memberof NgxPrintDirective
         * @param {?} values
         * @return {?}
         */
        function (values) {
            for (var key in values) {
                if (values.hasOwnProperty(key)) {
                    this._printStyle.push((key + JSON.stringify(values[key])).replace(/['"]+/g, ''));
                }
            }
            this.returnStyleValues();
        },
        enumerable: true,
        configurable: true
    });
    /**
     *
     *
     * @returns the string that create the stylesheet which will be injected
     * later within <style></style> tag.
     *
     * -join/replace to transform an array objects to css-styled string
     *
     * @memberof NgxPrintDirective
     */
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @return {?} the string that create the stylesheet which will be injected
     * later within <style></style> tag.
     *
     * -join/replace to transform an array objects to css-styled string
     *
     */
    NgxPrintDirective.prototype.returnStyleValues = /**
     *
     *
     * \@memberof NgxPrintDirective
     * @return {?} the string that create the stylesheet which will be injected
     * later within <style></style> tag.
     *
     * -join/replace to transform an array objects to css-styled string
     *
     */
    function () {
        return "<style> " + this._printStyle.join(' ').replace(/,/g, ';') + " </style>";
    };
    Object.defineProperty(NgxPrintDirective.prototype, "styleSheetFile", {
        /**
         * @memberof NgxPrintDirective
         * @param cssList
         */
        set: /**
         * \@memberof NgxPrintDirective
         * @param {?} cssList
         * @return {?}
         */
        function (cssList) {
            var e_1, _a;
            /** @type {?} */
            var linkTagFn = (/**
             * @param {?} cssFileName
             * @return {?}
             */
            function (cssFileName) {
                return "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + cssFileName + "\">";
            });
            if (cssList.indexOf(',') !== -1) {
                /** @type {?} */
                var valueArr = cssList.split(',');
                try {
                    for (var valueArr_1 = tslib_1.__values(valueArr), valueArr_1_1 = valueArr_1.next(); !valueArr_1_1.done; valueArr_1_1 = valueArr_1.next()) {
                        var val = valueArr_1_1.value;
                        this._styleSheetFile = this._styleSheetFile + linkTagFn(val);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (valueArr_1_1 && !valueArr_1_1.done && (_a = valueArr_1.return)) _a.call(valueArr_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            else {
                this._styleSheetFile = linkTagFn(cssList);
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @returns string which contains the link tags containing the css which will
     * be injected later within <head></head> tag.
     *
     */
    /**
     * @private
     * @return {?} string which contains the link tags containing the css which will
     * be injected later within <head></head> tag.
     *
     */
    NgxPrintDirective.prototype.returnStyleSheetLinkTags = /**
     * @private
     * @return {?} string which contains the link tags containing the css which will
     * be injected later within <head></head> tag.
     *
     */
    function () {
        return this._styleSheetFile;
    };
    /**
     * @private
     * @param {?} tag
     * @return {?}
     */
    NgxPrintDirective.prototype.getElementTag = /**
     * @private
     * @param {?} tag
     * @return {?}
     */
    function (tag) {
        /** @type {?} */
        var html = [];
        /** @type {?} */
        var elements = document.getElementsByTagName(tag);
        for (var index = 0; index < elements.length; index++) {
            html.push(elements[index].outerHTML);
        }
        return html.join('\r\n');
    };
    /**
     *
     * @param data the html element collection to save defaults to
     *
     */
    /**
     *
     * @private
     * @param {?} data the html element collection to save defaults to
     *
     * @return {?}
     */
    NgxPrintDirective.prototype.getFormData = /**
     *
     * @private
     * @param {?} data the html element collection to save defaults to
     *
     * @return {?}
     */
    function (data) {
        for (var i = 0; i < data.length; i++) {
            data[i].defaultValue = data[i].value;
            if (data[i].checked) {
                data[i].defaultChecked = true;
            }
        }
    };
    /**
     * @returns html section to be printed along with some associated inputs
     *
     */
    /**
     * @private
     * @return {?} html section to be printed along with some associated inputs
     *
     */
    NgxPrintDirective.prototype.getHtmlContents = /**
     * @private
     * @return {?} html section to be printed along with some associated inputs
     *
     */
    function () {
        /** @type {?} */
        var printContents = document.getElementById(this.printSectionId);
        /** @type {?} */
        var innards = printContents.getElementsByTagName('input');
        this.getFormData(innards);
        /** @type {?} */
        var txt = printContents.getElementsByTagName('textarea');
        this.getFormData(txt);
        return printContents.innerHTML;
    };
    /**
     *
     *
     * @memberof NgxPrintDirective
     */
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @return {?}
     */
    NgxPrintDirective.prototype.print = /**
     *
     *
     * \@memberof NgxPrintDirective
     * @return {?}
     */
    function () {
        /** @type {?} */
        var printContents;
        /** @type {?} */
        var popupWin;
        /** @type {?} */
        var styles = '';
        /** @type {?} */
        var links = '';
        /** @type {?} */
        var baseTag = this.getElementTag('base');
        if (this.useExistingCss) {
            styles = this.getElementTag('style');
            links = this.getElementTag('link');
        }
        printContents = this.getHtmlContents();
        popupWin = window.open("", "_blank", "top=0,left=0,height=auto,width=auto");
        popupWin.document.open();
        popupWin.document.write("\n      <html>\n        <head>\n          <title>" + (this.printTitle ? this.printTitle : "") + "</title>\n          " + baseTag + "\n          " + this.returnStyleValues() + "\n          " + this.returnStyleSheetLinkTags() + "\n          " + styles + "\n          " + links + "\n        </head>\n        <body>\n          " + printContents + "\n          <script defer>\n            function triggerPrint(event) {\n              window.removeEventListener('load', triggerPrint, false);\n              setTimeout(function() {\n                closeWindow(window.print());\n              }, " + this.printDelay + ");\n            }\n            function closeWindow(){\n                window.close();\n            }\n            window.addEventListener('load', triggerPrint, false);\n          </script>\n        </body>\n      </html>");
        popupWin.document.close();
    };
    NgxPrintDirective.decorators = [
        { type: Directive, args: [{
                    selector: "button[ngxPrint]"
                },] }
    ];
    NgxPrintDirective.propDecorators = {
        printSectionId: [{ type: Input }],
        printTitle: [{ type: Input }],
        useExistingCss: [{ type: Input }],
        printDelay: [{ type: Input }],
        printStyle: [{ type: Input }],
        styleSheetFile: [{ type: Input }],
        print: [{ type: HostListener, args: ['click',] }]
    };
    return NgxPrintDirective;
}());
export { NgxPrintDirective };
if (false) {
    /** @type {?} */
    NgxPrintDirective.prototype._printStyle;
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.printSectionId;
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.printTitle;
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.useExistingCss;
    /**
     * A delay in milliseconds to force the print dialog to wait before opened. Default: 0
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.printDelay;
    /**
     *
     *
     * \@return html for the given tag
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     * @private
     */
    NgxPrintDirective.prototype._styleSheetFile;
}
//# sourceMappingURL=data:application/json;base64,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