import { getBsVer } from 'ngx-bootstrap/utils';
const availablePositions = {
    top: ['top', 'top start', 'top end'],
    bottom: ['bottom', 'bottom start', 'bottom end'],
    start: ['start', 'start top', 'start bottom'],
    end: ['end', 'end top', 'end bottom']
};
export function checkPopoverMargin(placement, checkPosition) {
    if (!getBsVer().isBs5) {
        return false;
    }
    return availablePositions[checkPosition].includes(placement);
}
export function checkMargins(placement) {
    if (!getBsVer().isBs5) {
        return '';
    }
    if (checkPopoverMargin(placement, 'end')) {
        return 'ms-2';
    }
    if (checkPopoverMargin(placement, 'start')) {
        return 'me-2';
    }
    if (checkPopoverMargin(placement, 'top')) {
        return 'mb-2';
    }
    if (checkPopoverMargin(placement, 'bottom')) {
        return 'mt-2';
    }
    return '';
}
//# sourceMappingURL=data:application/json;base64,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