import { MapPlacementInToRL } from './models';
import { arrow, flip, initData, preventOverflow, shift } from './modifiers';
import { getOffsets, getReferenceOffsets, setStyles, updateContainerClass } from './utils';
export class Positioning {
    position(hostElement, targetElement /*, round = true*/) {
        return this.offset(hostElement, targetElement /*, false*/);
    }
    offset(hostElement, targetElement /*, round = true*/) {
        return getReferenceOffsets(targetElement, hostElement);
    }
    positionElements(hostElement, targetElement, position, appendToBody, options) {
        const chainOfModifiers = [flip, shift, preventOverflow, arrow];
        const _position = MapPlacementInToRL[position];
        const data = initData(targetElement, hostElement, _position, options);
        if (!data) {
            return;
        }
        return chainOfModifiers.reduce((modifiedData, modifier) => modifier(modifiedData), data);
    }
}
const positionService = new Positioning();
export function positionElements(hostElement, targetElement, placement, appendToBody, options, renderer) {
    const data = positionService.positionElements(hostElement, targetElement, placement, appendToBody, options);
    if (!data) {
        return;
    }
    const offsets = getOffsets(data);
    setStyles(targetElement, {
        'will-change': 'transform',
        top: '0px',
        left: '0px',
        transform: `translate3d(${offsets.left}px, ${offsets.top}px, 0px)`
    }, renderer);
    if (data.instance.arrow) {
        setStyles(data.instance.arrow, data.offsets.arrow, renderer);
    }
    updateContainerClass(data, renderer);
}
//# sourceMappingURL=data:application/json;base64,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