import { EventEmitter, NgZone, QueryList, AfterViewInit, SimpleChanges, OnChanges } from '@angular/core';
import { CKButtonDirective } from './ckbutton.directive';
import { CKGroupDirective } from './ckgroup.directive';
/**
 * CKEditor component
 * Usage :
 *  <ckeditor [(ngModel)]="data" [config]="{...}" debounce="500"></ckeditor>
 */
import * as ɵngcc0 from '@angular/core';
export declare class CKEditorComponent implements OnChanges, AfterViewInit {
    private zone;
    config: any;
    readonly: boolean;
    debounce: string;
    change: EventEmitter<any>;
    editorChange: EventEmitter<any>;
    ready: EventEmitter<any>;
    blur: EventEmitter<any>;
    focus: EventEmitter<any>;
    contentDom: EventEmitter<any>;
    fileUploadRequest: EventEmitter<any>;
    fileUploadResponse: EventEmitter<any>;
    paste: EventEmitter<any>;
    drop: EventEmitter<any>;
    host: any;
    toolbarButtons: QueryList<CKButtonDirective>;
    toolbarGroups: QueryList<CKGroupDirective>;
    _value: string;
    instance: any;
    debounceTimeout: any;
    /**
     * Constructor
     */
    constructor(zone: NgZone);
    get value(): any;
    set value(v: any);
    ngOnChanges(changes: SimpleChanges): void;
    /**
     * On component destroy
     */
    ngOnDestroy(): void;
    /**
     * On component view init
     */
    ngAfterViewInit(): void;
    /**
     * On component view checked
     */
    ngAfterViewChecked(): void;
    /**
     * Value update process
     */
    updateValue(value: any): void;
    /**
     * CKEditor init
     */
    ckeditorInit(config: any): void;
    /**
     * Implements ControlValueAccessor
     */
    writeValue(value: any): void;
    onChange(_: any): void;
    onTouched(): void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    private documentContains;
    static ɵfac: ɵngcc0.ɵɵFactoryDeclaration<CKEditorComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDeclaration<CKEditorComponent, "ckeditor", never, { "value": "value"; "config": "config"; "readonly": "readonly"; "debounce": "debounce"; }, { "change": "change"; "editorChange": "editorChange"; "ready": "ready"; "blur": "blur"; "focus": "focus"; "contentDom": "contentDom"; "fileUploadRequest": "fileUploadRequest"; "fileUploadResponse": "fileUploadResponse"; "paste": "paste"; "drop": "drop"; }, ["toolbarButtons", "toolbarGroups"], never, false>;
}

//# sourceMappingURL=ckeditor.component.d.ts.map