import { Directive, EventEmitter, Input, Output, } from '@angular/core';
import { Chart } from 'chart.js';
import { distinctUntilChanged } from 'rxjs/operators';
import { merge } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "./theme.service";
export class BaseChartDirective {
    constructor(element, zone, themeService) {
        this.zone = zone;
        this.themeService = themeService;
        this.type = 'bar';
        this.plugins = [];
        this.chartClick = new EventEmitter();
        this.chartHover = new EventEmitter();
        this.subs = [];
        this.ctx = element.nativeElement.getContext('2d');
        this.subs.push(this.themeService.colorschemesOptions
            .pipe(distinctUntilChanged())
            .subscribe(r => this.themeChanged(r)));
    }
    ngOnChanges(changes) {
        const requireRender = ['type'];
        const propertyNames = Object.getOwnPropertyNames(changes);
        if (propertyNames.some(key => requireRender.includes(key)) ||
            propertyNames.every(key => changes[key].isFirstChange())) {
            this.render();
        }
        else {
            const config = this.getChartConfiguration();
            if (this.chart) {
                Object.assign(this.chart.config.data, config.data);
                if (this.chart.config.plugins) {
                    Object.assign(this.chart.config.plugins, config.plugins);
                }
                if (this.chart.config.options) {
                    Object.assign(this.chart.config.options, config.options);
                }
            }
            this.update();
        }
    }
    ngOnDestroy() {
        if (this.chart) {
            this.chart.destroy();
            this.chart = void 0;
        }
        this.subs.forEach(s => s.unsubscribe());
    }
    render() {
        if (this.chart) {
            this.chart.destroy();
        }
        Chart.register(...this.plugins);
        return this.zone.runOutsideAngular(() => this.chart = new Chart(this.ctx, this.getChartConfiguration()));
    }
    update(duration) {
        if (this.chart) {
            this.zone.runOutsideAngular(() => this.chart?.update(duration));
        }
    }
    hideDataset(index, hidden) {
        if (this.chart) {
            this.chart.getDatasetMeta(index).hidden = hidden;
            this.update();
        }
    }
    isDatasetHidden(index) {
        return this.chart?.getDatasetMeta(index)?.hidden;
    }
    toBase64Image() {
        return this.chart?.toBase64Image();
    }
    themeChanged(options) {
        this.themeOverrides = options;
        if (this.chart) {
            if (this.chart.config.options) {
                Object.assign(this.chart.config.options, this.getChartOptions());
            }
            this.update();
        }
    }
    getChartOptions() {
        return merge({
            onHover: (event, active) => {
                if (!this.chartHover.observed && !this.chartHover.observers?.length) {
                    return;
                }
                this.zone.run(() => this.chartHover.emit({ event, active }));
            },
            onClick: (event, active) => {
                if (!this.chartClick.observed && !this.chartClick.observers?.length) {
                    return;
                }
                this.zone.run(() => this.chartClick.emit({ event, active }));
            }
        }, this.themeOverrides, this.options, {
            plugins: {
                legend: {
                    display: this.legend
                }
            }
        });
    }
    getChartConfiguration() {
        return {
            type: this.type,
            data: this.getChartData(),
            options: this.getChartOptions()
        };
    }
    getChartData() {
        return this.data ? this.data : {
            labels: this.labels || [],
            datasets: this.datasets || []
        };
    }
}
BaseChartDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BaseChartDirective, deps: [{ token: i0.ElementRef }, { token: i0.NgZone }, { token: i1.ThemeService }], target: i0.ɵɵFactoryTarget.Directive });
BaseChartDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: BaseChartDirective, selector: "canvas[baseChart]", inputs: { type: "type", legend: "legend", data: "data", options: "options", plugins: "plugins", labels: "labels", datasets: "datasets" }, outputs: { chartClick: "chartClick", chartHover: "chartHover" }, exportAs: ["base-chart"], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BaseChartDirective, decorators: [{
            type: Directive,
            args: [{
                    // eslint-disable-next-line @angular-eslint/directive-selector
                    selector: 'canvas[baseChart]',
                    exportAs: 'base-chart',
                }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i0.NgZone }, { type: i1.ThemeService }]; }, propDecorators: { type: [{
                type: Input
            }], legend: [{
                type: Input
            }], data: [{
                type: Input
            }], options: [{
                type: Input
            }], plugins: [{
                type: Input
            }], labels: [{
                type: Input
            }], datasets: [{
                type: Input
            }], chartClick: [{
                type: Output
            }], chartHover: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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