import { AfterContentChecked, ComponentFactoryResolver, ComponentRef, ElementRef, Injector, NgModuleRef, OnDestroy, OnInit, QueryList, Renderer2, ViewContainerRef } from '@angular/core';
import { Subscription } from 'rxjs';
import { IToasterAction, ToasterService } from './toaster.service';
import { ToasterHostDirective } from './toaster-host.directive';
import * as i0 from "@angular/core";
export declare enum ToasterPlacement {
    Static = "static",
    TopStart = "top-start",
    TopCenter = "top-center",
    TopEnd = "top-end",
    MiddleStart = "middle-start",
    MiddleCenter = "middle-center",
    MiddleEnd = "middle-end",
    BottomStart = "bottom-start",
    BottomCenter = "bottom-center",
    BottomEnd = "bottom-end"
}
export declare type TToasterPlacement = ToasterPlacement.Static | ToasterPlacement.TopStart | ToasterPlacement.TopCenter | ToasterPlacement.TopEnd | ToasterPlacement.MiddleStart | ToasterPlacement.MiddleCenter | ToasterPlacement.MiddleEnd | ToasterPlacement.BottomStart | ToasterPlacement.BottomCenter | ToasterPlacement.BottomEnd | string;
export declare class ToasterComponent implements OnDestroy, OnInit, AfterContentChecked {
    private componentFactoryResolver;
    private hostElement;
    private renderer;
    private toasterService;
    stateToasterSubscription: Subscription;
    placements: ToasterPlacement[];
    toasts: QueryList<ViewContainerRef>;
    toastsDynamic: any[];
    /**
     * Toaster placement
     * @type TToasterPlacement
     */
    placement: TToasterPlacement;
    /**
     * Toaster position
     * @type (string | 'absolute' | 'fixed' | 'static')
     */
    position: (string | 'absolute' | 'fixed' | 'static');
    toasterHost: ToasterHostDirective;
    contentToasts: QueryList<ViewContainerRef>;
    constructor(componentFactoryResolver: ComponentFactoryResolver, hostElement: ElementRef, renderer: Renderer2, toasterService: ToasterService);
    get hostClasses(): any;
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngAfterContentChecked(): void;
    addToast(toast: any, props: any, options?: {
        index?: number;
        injector?: Injector;
        ngModuleRef?: NgModuleRef<unknown>;
        projectableNodes?: Node[][];
    }): ComponentRef<any>;
    removeToast(state: IToasterAction): void;
    private stateToasterSubscribe;
    static ɵfac: i0.ɵɵFactoryDeclaration<ToasterComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ToasterComponent, "c-toaster", ["cToaster"], { "placement": "placement"; "position": "position"; }, {}, ["contentToasts"], ["*"], false>;
}
