import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class TableDirective {
    constructor(renderer, hostElement) {
        this.renderer = renderer;
        this.hostElement = hostElement;
        this._bordered = false;
        this._borderless = false;
        this._hover = false;
        this._small = false;
        this._striped = false;
    }
    /**
     * Add borders on all sides of the table and cells.
     * @type boolean
     */
    set bordered(value) {
        this._bordered = coerceBooleanProperty(value);
    }
    ;
    get bordered() {
        return this._bordered;
    }
    /**
     * Remove borders on all sides of the table and cells.
     * @type boolean
     */
    set borderless(value) {
        this._borderless = coerceBooleanProperty(value);
    }
    ;
    get borderless() {
        return this._borderless;
    }
    /**
     * Enable a hover state on table rows within table body.
     * @type boolean
     */
    set hover(value) {
        this._hover = coerceBooleanProperty(value);
    }
    ;
    get hover() {
        return this._hover;
    }
    /**
     * Make table more compact by cutting all cell `padding` in half.
     * @type boolean
     */
    set small(value) {
        this._small = coerceBooleanProperty(value);
    }
    ;
    get small() {
        return this._small;
    }
    /**
     * Add zebra-striping to any table row within the table body`.
     * @type boolean
     */
    set striped(value) {
        this._striped = coerceBooleanProperty(value);
    }
    ;
    get striped() {
        return this._striped;
    }
    get hostClasses() {
        return {
            table: true,
            [`align-${this.align}`]: !!this.align,
            [`caption-${this.caption}`]: !!this.caption,
            [`border-${this.borderColor}`]: !!this.borderColor,
            'table-bordered': this.bordered,
            'table-borderless': this.borderless,
            [`table-${this.color}`]: !!this.color,
            'table-hover': this.hover,
            'table-sm': this.small,
            'table-striped': this.striped
        };
    }
    ngOnInit() {
        this.setResponsiveWrapper();
    }
    // todo
    setResponsiveWrapper() {
        if (!!this.responsive) {
            const nativeElement = this.hostElement.nativeElement;
            const wrapper = this.renderer.createElement('div');
            const className = this.responsive === true ? 'table-responsive' : `table-responsive-${this.responsive}`;
            this.renderer.addClass(wrapper, className);
            const parentNode = this.renderer.parentNode(nativeElement);
            this.renderer.appendChild(parentNode, wrapper);
            this.renderer.insertBefore(parentNode, wrapper, nativeElement);
            this.renderer.appendChild(wrapper, nativeElement);
        }
    }
}
TableDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: TableDirective, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
TableDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: TableDirective, selector: "[cTable]", inputs: { align: "align", borderColor: "borderColor", bordered: "bordered", borderless: "borderless", caption: "caption", color: "color", hover: "hover", responsive: "responsive", small: "small", striped: "striped" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: TableDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cTable]'
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }]; }, propDecorators: { align: [{
                type: Input
            }], borderColor: [{
                type: Input
            }], bordered: [{
                type: Input
            }], borderless: [{
                type: Input
            }], caption: [{
                type: Input
            }], color: [{
                type: Input
            }], hover: [{
                type: Input
            }], responsive: [{
                type: Input
            }], small: [{
                type: Input
            }], striped: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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