import { Component, EventEmitter, Input, Output } from '@angular/core';
import { NavigationEnd } from '@angular/router';
import { filter } from 'rxjs/operators';
import { SidebarNavHelper } from './sidebar-nav.service';
import * as i0 from "@angular/core";
import * as i1 from "./sidebar-nav.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/router";
import * as i4 from "../../shared/html-attr.directive";
import * as i5 from "@coreui/icons-angular";
import * as i6 from "./sidebar-nav-badge.pipe";
import * as i7 from "./sidebar-nav-icon.pipe";
import * as i8 from "./sidebar-nav-link.pipe";
export class SidebarNavLinkContentComponent {
    constructor(helper) {
        this.helper = helper;
    }
}
SidebarNavLinkContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavLinkContentComponent, deps: [{ token: i1.SidebarNavHelper }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavLinkContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: SidebarNavLinkContentComponent, selector: "c-sidebar-nav-link-content", inputs: { item: "item" }, providers: [SidebarNavHelper], ngImport: i0, template: `
    <ng-container *ngIf="true">
      <ng-container>{{item?.name ?? ''}}</ng-container>
    </ng-container>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavLinkContentComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-sidebar-nav-link-content',
                    template: `
    <ng-container *ngIf="true">
      <ng-container>{{item?.name ?? ''}}</ng-container>
    </ng-container>
  `,
                    providers: [SidebarNavHelper]
                }]
        }], ctorParameters: function () { return [{ type: i1.SidebarNavHelper }]; }, propDecorators: { item: [{
                type: Input
            }] } });
export class SidebarNavLinkComponent {
    constructor(router) {
        this.router = router;
        // tslint:disable-next-line:variable-name
        this._item = {};
        this.linkClick = new EventEmitter();
        this.navigationEndObservable = router.events.pipe(filter(event => {
            return event instanceof NavigationEnd;
        }));
    }
    set item(item) {
        this._item = JSON.parse(JSON.stringify(item));
    }
    get item() {
        return this._item;
    }
    ngOnInit() {
        // @ts-ignore
        this.url = typeof this.item.url === 'string' ? this.item.url : this.router.serializeUrl(this.router.createUrlTree(this.item.url));
        this.linkType = this.getLinkType();
        this.href = this.isDisabled() ? '' : (this.item.href || this.url);
        this.linkActive = this.router.url.split(/[?#(;]/)[0] === this.href.split(/[?#(;]/)[0];
        this.navSubscription = this.navigationEndObservable.subscribe(event => {
            const itemUrlArray = this.href.split(/[?#(;]/)[0].split('/');
            const urlArray = event.urlAfterRedirects.split(/[?#(;]/)[0].split('/');
            this.linkActive = itemUrlArray.every((value, index) => value === urlArray[index]);
        });
    }
    ngOnDestroy() {
        this.navSubscription.unsubscribe();
    }
    getLinkType() {
        return this.isDisabled() ? 'disabled' : this.isExternalLink() ? 'external' : 'link';
    }
    isDisabled() {
        return this.item?.attributes?.['disabled'];
    }
    isExternalLink() {
        const linkPath = Array.isArray(this.item.url) ? this.item.url[0] : this.item.url;
        return !!this.item.href || linkPath.substring(0, 4) === 'http';
    }
    linkClicked() {
        this.linkClick.emit();
    }
}
SidebarNavLinkComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavLinkComponent, deps: [{ token: i3.Router }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavLinkComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: SidebarNavLinkComponent, selector: "c-sidebar-nav-link", inputs: { item: "item" }, outputs: { linkClick: "linkClick" }, providers: [SidebarNavHelper], ngImport: i0, template: "<ng-container [ngSwitch]=\"linkType\">\r\n  <a *ngSwitchCase=\"'disabled'\"\r\n     [ngClass]=\"item | cSidebarNavLink\"\r\n     [cHtmlAttr]=\"item.attributes ?? {}\"\r\n  >\r\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\r\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\r\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\r\n  </a>\r\n  <a *ngSwitchCase=\"'external'\"\r\n     [ngClass]=\"item | cSidebarNavLink\"\r\n     [href]=\"href\"\r\n     [cHtmlAttr]=\"item.attributes ?? {}\"\r\n     (click)=\"linkClicked()\"\r\n  >\r\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\r\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\r\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\r\n  </a>\r\n  <a *ngSwitchDefault\r\n     [ngClass]=\"item | cSidebarNavLink\"\r\n     [cHtmlAttr]=\"item.attributes ?? {}\"\r\n     [target]=\"item.attributes?.['target']\"\r\n     [queryParams]=\"item.linkProps?.queryParams ?? null\"\r\n     [fragment]=\"item.linkProps?.fragment\"\r\n     [queryParamsHandling]=\"item.linkProps?.queryParamsHandling\"\r\n     [preserveFragment]=\"item.linkProps?.preserveFragment ?? false\"\r\n     [skipLocationChange]=\"item.linkProps?.skipLocationChange ?? false\"\r\n     [replaceUrl]=\"item.linkProps?.replaceUrl ?? false\"\r\n     [state]=\"item.linkProps?.state ?? {}\"\r\n     [routerLink]=\"item.url\"\r\n     routerLinkActive=\"active\"\r\n     [routerLinkActiveOptions]=\"item.linkProps?.routerLinkActiveOptions ?? { exact: false }\"\r\n     (click)=\"linkClicked()\"\r\n  >\r\n<!--    [class.active]=\"linkActive\"-->\r\n    <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\r\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\r\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\r\n  </a>\r\n</ng-container>\r\n\r\n<ng-template #iconTemplate let-item>\r\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\r\n  <ng-template [ngIf]=\"item?.iconComponent\">\r\n    <svg\r\n      [cIcon]=\"item.iconComponent?.content\"\r\n      [name]=\"item.iconComponent?.name\"\r\n      [customClasses]=\"item | cSidebarNavIcon\"\r\n    ></svg>\r\n  </ng-template>\r\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\r\n</ng-template>\r\n", dependencies: [{ kind: "directive", type: i2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i2.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i2.NgSwitch, selector: "[ngSwitch]", inputs: ["ngSwitch"] }, { kind: "directive", type: i2.NgSwitchCase, selector: "[ngSwitchCase]", inputs: ["ngSwitchCase"] }, { kind: "directive", type: i2.NgSwitchDefault, selector: "[ngSwitchDefault]" }, { kind: "directive", type: i3.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "preserveFragment", "skipLocationChange", "replaceUrl", "state", "relativeTo", "routerLink"] }, { kind: "directive", type: i3.RouterLinkActive, selector: "[routerLinkActive]", inputs: ["routerLinkActiveOptions", "ariaCurrentWhenActive", "routerLinkActive"], outputs: ["isActiveChange"], exportAs: ["routerLinkActive"] }, { kind: "directive", type: i4.HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }, { kind: "directive", type: i5.IconDirective, selector: "svg[cIcon]", inputs: ["cIcon", "size", "title", "customClasses", "width", "height", "name", "viewBox", "xmlns", "pointer-events", "role"], exportAs: ["cIcon"] }, { kind: "component", type: SidebarNavLinkContentComponent, selector: "c-sidebar-nav-link-content", inputs: ["item"] }, { kind: "pipe", type: i6.SidebarNavBadgePipe, name: "cSidebarNavBadge" }, { kind: "pipe", type: i7.SidebarNavIconPipe, name: "cSidebarNavIcon" }, { kind: "pipe", type: i8.SidebarNavLinkPipe, name: "cSidebarNavLink" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavLinkComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-sidebar-nav-link', providers: [SidebarNavHelper], template: "<ng-container [ngSwitch]=\"linkType\">\r\n  <a *ngSwitchCase=\"'disabled'\"\r\n     [ngClass]=\"item | cSidebarNavLink\"\r\n     [cHtmlAttr]=\"item.attributes ?? {}\"\r\n  >\r\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\r\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\r\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\r\n  </a>\r\n  <a *ngSwitchCase=\"'external'\"\r\n     [ngClass]=\"item | cSidebarNavLink\"\r\n     [href]=\"href\"\r\n     [cHtmlAttr]=\"item.attributes ?? {}\"\r\n     (click)=\"linkClicked()\"\r\n  >\r\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\r\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\r\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\r\n  </a>\r\n  <a *ngSwitchDefault\r\n     [ngClass]=\"item | cSidebarNavLink\"\r\n     [cHtmlAttr]=\"item.attributes ?? {}\"\r\n     [target]=\"item.attributes?.['target']\"\r\n     [queryParams]=\"item.linkProps?.queryParams ?? null\"\r\n     [fragment]=\"item.linkProps?.fragment\"\r\n     [queryParamsHandling]=\"item.linkProps?.queryParamsHandling\"\r\n     [preserveFragment]=\"item.linkProps?.preserveFragment ?? false\"\r\n     [skipLocationChange]=\"item.linkProps?.skipLocationChange ?? false\"\r\n     [replaceUrl]=\"item.linkProps?.replaceUrl ?? false\"\r\n     [state]=\"item.linkProps?.state ?? {}\"\r\n     [routerLink]=\"item.url\"\r\n     routerLinkActive=\"active\"\r\n     [routerLinkActiveOptions]=\"item.linkProps?.routerLinkActiveOptions ?? { exact: false }\"\r\n     (click)=\"linkClicked()\"\r\n  >\r\n<!--    [class.active]=\"linkActive\"-->\r\n    <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\r\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\r\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\r\n  </a>\r\n</ng-container>\r\n\r\n<ng-template #iconTemplate let-item>\r\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\r\n  <ng-template [ngIf]=\"item?.iconComponent\">\r\n    <svg\r\n      [cIcon]=\"item.iconComponent?.content\"\r\n      [name]=\"item.iconComponent?.name\"\r\n      [customClasses]=\"item | cSidebarNavIcon\"\r\n    ></svg>\r\n  </ng-template>\r\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\r\n</ng-template>\r\n" }]
        }], ctorParameters: function () { return [{ type: i3.Router }]; }, propDecorators: { item: [{
                type: Input
            }], linkClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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