import { ContentChild, Directive, HostBinding, Input } from '@angular/core';
import { PlaceholderDirective } from './placeholder.directive';
import * as i0 from "@angular/core";
export class PlaceholderAnimationDirective {
    constructor() {
        this.animate = false;
    }
    get hostClasses() {
        return {
            [`placeholder-${this.animation}`]: this.animate && !!this.animation
        };
    }
    ngAfterContentInit() {
        this.animate = this.placeholder?.visible;
    }
}
PlaceholderAnimationDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: PlaceholderAnimationDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
PlaceholderAnimationDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: PlaceholderAnimationDirective, selector: "[cPlaceholderAnimation]", inputs: { animation: ["cPlaceholderAnimation", "animation"] }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "placeholder", first: true, predicate: PlaceholderDirective, descendants: true }], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: PlaceholderAnimationDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cPlaceholderAnimation]'
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { animation: [{
                type: Input,
                args: ['cPlaceholderAnimation']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], placeholder: [{
                type: ContentChild,
                args: [PlaceholderDirective]
            }] } });
//# sourceMappingURL=data:application/json;base64,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