import { Component, HostBinding, HostListener } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/cdk/a11y";
export class ModalContentComponent {
    constructor(hostElement, interactivityChecker) {
        this.hostElement = hostElement;
        this.interactivityChecker = interactivityChecker;
    }
    get hostClasses() {
        return {
            'modal-content': true
        };
    }
    onClickHandler($event) {
        $event.stopPropagation();
        const targetElement = $event.target;
        return this.hostElement?.nativeElement?.contains(targetElement) &&
            this.interactivityChecker.isFocusable(targetElement);
    }
}
ModalContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ModalContentComponent, deps: [{ token: i0.ElementRef }, { token: i1.InteractivityChecker }], target: i0.ɵɵFactoryTarget.Component });
ModalContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: ModalContentComponent, selector: "c-modal-content", host: { listeners: { "click": "onClickHandler($event)" }, properties: { "class": "this.hostClasses" } }, ngImport: i0, template: '<ng-content></ng-content>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ModalContentComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-modal-content',
                    template: '<ng-content></ng-content>'
                }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i1.InteractivityChecker }]; }, propDecorators: { hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], onClickHandler: [{
                type: HostListener,
                args: ['click', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kYWwtY29udGVudC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9jb3JldWktYW5ndWxhci9zcmMvbGliL21vZGFsL21vZGFsLWNvbnRlbnQvbW9kYWwtY29udGVudC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBYyxXQUFXLEVBQUUsWUFBWSxFQUFFLE1BQU0sZUFBZSxDQUFDOzs7QUFPakYsTUFBTSxPQUFPLHFCQUFxQjtJQUVoQyxZQUNVLFdBQXVCLEVBQ3ZCLG9CQUEwQztRQUQxQyxnQkFBVyxHQUFYLFdBQVcsQ0FBWTtRQUN2Qix5QkFBb0IsR0FBcEIsb0JBQW9CLENBQXNCO0lBQ2hELENBQUM7SUFFTCxJQUNJLFdBQVc7UUFDYixPQUFPO1lBQ0wsZUFBZSxFQUFFLElBQUk7U0FDdEIsQ0FBQztJQUNKLENBQUM7SUFHTSxjQUFjLENBQUMsTUFBa0I7UUFDdEMsTUFBTSxDQUFDLGVBQWUsRUFBRSxDQUFDO1FBQ3pCLE1BQU0sYUFBYSxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUMsV0FBVyxFQUFFLGFBQWEsRUFBRSxRQUFRLENBQUMsYUFBYSxDQUFDO1lBQzdELElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxXQUFXLENBQUUsYUFBNkIsQ0FBQyxDQUFDO0lBQzFFLENBQUM7O2tIQXBCVSxxQkFBcUI7c0dBQXJCLHFCQUFxQixnS0FGdEIsMkJBQTJCOzJGQUUxQixxQkFBcUI7a0JBSmpDLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLGlCQUFpQjtvQkFDM0IsUUFBUSxFQUFFLDJCQUEyQjtpQkFDdEM7b0lBU0ssV0FBVztzQkFEZCxXQUFXO3VCQUFDLE9BQU87Z0JBUWIsY0FBYztzQkFEcEIsWUFBWTt1QkFBQyxPQUFPLEVBQUUsQ0FBQyxRQUFRLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIEVsZW1lbnRSZWYsIEhvc3RCaW5kaW5nLCBIb3N0TGlzdGVuZXIgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEludGVyYWN0aXZpdHlDaGVja2VyIH0gZnJvbSAnQGFuZ3VsYXIvY2RrL2ExMXknO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdjLW1vZGFsLWNvbnRlbnQnLFxuICB0ZW1wbGF0ZTogJzxuZy1jb250ZW50PjwvbmctY29udGVudD4nXG59KVxuZXhwb3J0IGNsYXNzIE1vZGFsQ29udGVudENvbXBvbmVudCB7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSBob3N0RWxlbWVudDogRWxlbWVudFJlZixcbiAgICBwcml2YXRlIGludGVyYWN0aXZpdHlDaGVja2VyOiBJbnRlcmFjdGl2aXR5Q2hlY2tlclxuICApIHsgfVxuXG4gIEBIb3N0QmluZGluZygnY2xhc3MnKVxuICBnZXQgaG9zdENsYXNzZXMoKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgJ21vZGFsLWNvbnRlbnQnOiB0cnVlXG4gICAgfTtcbiAgfVxuXG4gIEBIb3N0TGlzdGVuZXIoJ2NsaWNrJywgWyckZXZlbnQnXSlcbiAgcHVibGljIG9uQ2xpY2tIYW5kbGVyKCRldmVudDogTW91c2VFdmVudCk6IGJvb2xlYW4ge1xuICAgICRldmVudC5zdG9wUHJvcGFnYXRpb24oKTtcbiAgICBjb25zdCB0YXJnZXRFbGVtZW50ID0gJGV2ZW50LnRhcmdldDtcbiAgICByZXR1cm4gdGhpcy5ob3N0RWxlbWVudD8ubmF0aXZlRWxlbWVudD8uY29udGFpbnModGFyZ2V0RWxlbWVudCkgJiZcbiAgICAgIHRoaXMuaW50ZXJhY3Rpdml0eUNoZWNrZXIuaXNGb2N1c2FibGUoKHRhcmdldEVsZW1lbnQgYXMgSFRNTEVsZW1lbnQpKTtcbiAgfVxufVxuIl19