import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class ImgDirective {
    constructor() {
        /**
         * Set the horizontal aligment.
         * @type {'' | 'start' | 'end' | 'center'}
         */
        this.align = '';
        this._fluid = false;
        this._rounded = false;
        this._thumbnail = false;
        /**
         * Color for image placeholder.
         */
        this.placeholderColor = 'transparent';
    }
    /**
     * Make image responsive.
     * @type boolean
     */
    set fluid(value) {
        this._fluid = coerceBooleanProperty(value);
    }
    ;
    get fluid() {
        return this._fluid;
    }
    /**
     * Make image rounded.
     * @type boolean
     */
    set rounded(value) {
        this._rounded = coerceBooleanProperty(value);
    }
    ;
    get rounded() {
        return this._rounded;
    }
    /**
     * Give an image a rounded 1px border appearance.
     * @type boolean
     */
    set thumbnail(value) {
        this._thumbnail = coerceBooleanProperty(value);
    }
    ;
    get thumbnail() {
        return this._thumbnail;
    }
    get getStyles() {
        return { backgroundColor: this.placeholderColor };
    }
    get hostClasses() {
        const align = this.align;
        return {
            [`float-${align}`]: align === 'start' || align === 'end',
            'd-block': align === 'center',
            'mx-auto': align === 'center',
            'img-fluid': this.fluid,
            'rounded': this.rounded,
            'img-thumbnail': this.thumbnail,
        };
    }
}
ImgDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ImgDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
ImgDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: ImgDirective, selector: "[cImg]", inputs: { align: "align", fluid: "fluid", rounded: "rounded", thumbnail: "thumbnail", placeholderColor: "placeholderColor" }, host: { properties: { "style": "this.getStyles", "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ImgDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cImg]'
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { align: [{
                type: Input
            }], fluid: [{
                type: Input
            }], rounded: [{
                type: Input
            }], thumbnail: [{
                type: Input
            }], placeholderColor: [{
                type: Input
            }], getStyles: [{
                type: HostBinding,
                args: ['style']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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