import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class ButtonDirective {
    constructor() {
        this._active = false;
        this._disabled = false;
        /**
         * Sets the color context of the component to one of CoreUI’s themed colors. [docs]
         * @type Colors
         */
        this.color = 'primary';
        /**
         * Size the component small or large.
         * @type {'sm' | 'lg'}
         */
        this.size = '';
        /**
         * Specifies the type of button. Always specify the type attribute for the `<button>` element.
         * Different browsers may use different default types for the `<button>` element.
         */
        this.type = 'button';
    }
    /**
     * Toggle the active state for the component. [docs]
     * @type boolean
     */
    get active() {
        return this._active;
    }
    set active(value) {
        this._active = coerceBooleanProperty(value);
    }
    /**
     * Toggle the disabled state for the component.
     * @type boolean
     */
    get disabled() {
        return this._disabled;
    }
    set disabled(value) {
        this._disabled = coerceBooleanProperty(value);
    }
    get hostClasses() {
        return {
            btn: true,
            [`btn-${this.color}`]: !!this.color && !this.variant,
            [`btn-${this.variant}`]: !!this.variant && !this.color,
            [`btn-${this.variant}-${this.color}`]: !!this.variant && !!this.color,
            [`btn-${this.size}`]: !!this.size,
            [`${this.shape}`]: !!this.shape,
            disabled: this.disabled,
            active: this.active
        };
    }
    get ariaDisabled() {
        return this.disabled || null;
    }
    ;
    get isActive() {
        return this.active || null;
    }
    get attrDisabled() {
        return this.disabled ? '' : null;
    }
    ;
    get tabIndex() {
        return this.disabled ? '-1' : null;
    }
}
ButtonDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ButtonDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
ButtonDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: ButtonDirective, selector: "[cButton]", inputs: { active: "active", color: "color", disabled: "disabled", shape: "shape", size: "size", type: "type", variant: "variant" }, host: { properties: { "attr.type": "this.type", "class": "this.hostClasses", "attr.aria-disabled": "this.ariaDisabled", "attr.aria-pressed": "this.isActive", "attr.disabled": "this.attrDisabled", "attr.tabindex": "this.tabIndex" } }, exportAs: ["cButton"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ButtonDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cButton]',
                    exportAs: 'cButton'
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { active: [{
                type: Input
            }], color: [{
                type: Input
            }], disabled: [{
                type: Input
            }], shape: [{
                type: Input
            }], size: [{
                type: Input
            }], type: [{
                type: HostBinding,
                args: ['attr.type']
            }, {
                type: Input
            }], variant: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], ariaDisabled: [{
                type: HostBinding,
                args: ['attr.aria-disabled']
            }], isActive: [{
                type: HostBinding,
                args: ['attr.aria-pressed']
            }], attrDisabled: [{
                type: HostBinding,
                args: ['attr.disabled']
            }], tabIndex: [{
                type: HostBinding,
                args: ['attr.tabindex']
            }] } });
//# sourceMappingURL=data:application/json;base64,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