import { Component, ContentChildren, HostBinding, Input, } from '@angular/core';
import { TemplateIdDirective } from '../../shared';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
import * as i1 from "../accordion.service";
import * as i2 from "@angular/common";
import * as i3 from "../../collapse/collapse.directive";
import * as i4 from "../accordion-button/accordion-button.directive";
let nextId = 0;
export class AccordionItemComponent {
    constructor(accordionService) {
        this.accordionService = accordionService;
        this._visible = false;
        this.contentId = `accordion-item-${nextId++}`;
        this.itemContext = { $implicit: this.visible };
        this.templates = {};
    }
    /**
     * Toggle an accordion item programmatically
     * @type boolean
     * @default false
     */
    set visible(value) {
        this._visible = coerceBooleanProperty(value);
    }
    get visible() {
        return this._visible;
    }
    set open(value) {
        console.warn('c-accordion-item "open" prop is deprecated, use "visible"  prop instead.');
        this.visible = value || this.visible;
    }
    get open() {
        return this.visible;
    }
    get hostClasses() {
        return {
            'accordion-item': true,
        };
    }
    ngOnInit() {
        this.accordionService.addItem(this);
    }
    ngOnDestroy() {
        this.accordionService.removeItem(this);
    }
    toggleItem() {
        this.accordionService.toggleItem(this);
    }
    ngAfterContentInit() {
        this.contentTemplates.forEach((child) => {
            this.templates[child.id] = child.templateRef;
        });
    }
}
AccordionItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionItemComponent, deps: [{ token: i1.AccordionService }], target: i0.ɵɵFactoryTarget.Component });
AccordionItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: AccordionItemComponent, selector: "c-accordion-item", inputs: { visible: "visible", open: "open" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "contentTemplates", predicate: TemplateIdDirective, descendants: true }], exportAs: ["cAccordionItem"], ngImport: i0, template: "<ng-container>\r\n  <div class=\"accordion-header\">\r\n    <ng-container *ngTemplateOutlet=\"templates['accordionHeaderTemplate'] || defaultAccordionHeaderTemplate; context: itemContext\"></ng-container>\r\n  </div>\r\n  <div class=\"accordion-collapse\" cCollapse [visible]=\"visible\" [attr.aria-expanded]=\"visible\" [id]=\"contentId\">\r\n    <ng-container *ngTemplateOutlet=\"templates['accordionBodyTemplate'] || defaultAccordionBodyTemplate; context: itemContext\"></ng-container>\r\n  </div>\r\n</ng-container>\r\n\r\n<ng-template #defaultAccordionHeaderTemplate>\r\n  <button cAccordionButton [collapsed]=\"!visible\" [attr.aria-controls]=\"contentId\" (click)=\"toggleItem()\">\r\n    <ng-container\r\n      *ngTemplateOutlet=\"templates['accordionHeader'] || defaultAccordionHeaderContentTemplate; context: itemContext\">\r\n    </ng-container>\r\n  </button>\r\n</ng-template>\r\n\r\n<ng-template #defaultAccordionHeaderContentTemplate>\r\n  <ng-content></ng-content>\r\n</ng-template>\r\n\r\n<ng-template #defaultAccordionBodyTemplate>\r\n  <div class=\"accordion-body\">\r\n    <ng-container\r\n      *ngTemplateOutlet=\"templates['accordionBody'] || defaultAccordionBodyContentTemplate; context: itemContext\">\r\n    </ng-container>\r\n  </div>\r\n</ng-template>\r\n\r\n<ng-template #defaultAccordionBodyContentTemplate>\r\n  <ng-content></ng-content>\r\n</ng-template>\r\n", styles: [":host{display:block;overflow:hidden}\n"], dependencies: [{ kind: "directive", type: i2.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i3.CollapseDirective, selector: "[cCollapse]", inputs: ["animate", "horizontal", "visible", "navbar", "duration", "transition"], outputs: ["collapseChange"], exportAs: ["cCollapse"] }, { kind: "directive", type: i4.AccordionButtonDirective, selector: "[cAccordionButton]", inputs: ["collapsed", "type"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionItemComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-accordion-item', exportAs: 'cAccordionItem', template: "<ng-container>\r\n  <div class=\"accordion-header\">\r\n    <ng-container *ngTemplateOutlet=\"templates['accordionHeaderTemplate'] || defaultAccordionHeaderTemplate; context: itemContext\"></ng-container>\r\n  </div>\r\n  <div class=\"accordion-collapse\" cCollapse [visible]=\"visible\" [attr.aria-expanded]=\"visible\" [id]=\"contentId\">\r\n    <ng-container *ngTemplateOutlet=\"templates['accordionBodyTemplate'] || defaultAccordionBodyTemplate; context: itemContext\"></ng-container>\r\n  </div>\r\n</ng-container>\r\n\r\n<ng-template #defaultAccordionHeaderTemplate>\r\n  <button cAccordionButton [collapsed]=\"!visible\" [attr.aria-controls]=\"contentId\" (click)=\"toggleItem()\">\r\n    <ng-container\r\n      *ngTemplateOutlet=\"templates['accordionHeader'] || defaultAccordionHeaderContentTemplate; context: itemContext\">\r\n    </ng-container>\r\n  </button>\r\n</ng-template>\r\n\r\n<ng-template #defaultAccordionHeaderContentTemplate>\r\n  <ng-content></ng-content>\r\n</ng-template>\r\n\r\n<ng-template #defaultAccordionBodyTemplate>\r\n  <div class=\"accordion-body\">\r\n    <ng-container\r\n      *ngTemplateOutlet=\"templates['accordionBody'] || defaultAccordionBodyContentTemplate; context: itemContext\">\r\n    </ng-container>\r\n  </div>\r\n</ng-template>\r\n\r\n<ng-template #defaultAccordionBodyContentTemplate>\r\n  <ng-content></ng-content>\r\n</ng-template>\r\n", styles: [":host{display:block;overflow:hidden}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AccordionService }]; }, propDecorators: { visible: [{
                type: Input
            }], open: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], contentTemplates: [{
                type: ContentChildren,
                args: [TemplateIdDirective, { descendants: true }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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