/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { ALLOW_MULTIPLE_PLATFORMS as ɵALLOW_MULTIPLE_PLATFORMS, internalBootstrapApplication as ɵinternalBootstrapApplication } from './application_ref';
export { APP_ID_RANDOM_PROVIDER as ɵAPP_ID_RANDOM_PROVIDER } from './application_tokens';
export { defaultIterableDiffers as ɵdefaultIterableDiffers, defaultKeyValueDiffers as ɵdefaultKeyValueDiffers } from './change_detection/change_detection';
export { ChangeDetectorStatus as ɵChangeDetectorStatus, isDefaultChangeDetectionStrategy as ɵisDefaultChangeDetectionStrategy } from './change_detection/constants';
export { Console as ɵConsole } from './console';
export { getDebugNodeR2 as ɵgetDebugNodeR2 } from './debug/debug_node';
export { setCurrentInjector as ɵsetCurrentInjector } from './di/injector_compatibility';
export { getInjectableDef as ɵgetInjectableDef } from './di/interface/defs';
export { INJECTOR_SCOPE as ɵINJECTOR_SCOPE } from './di/scope';
export { RuntimeError as ɵRuntimeError } from './errors';
export { findLocaleData as ɵfindLocaleData, getLocaleCurrencyCode as ɵgetLocaleCurrencyCode, getLocalePluralCase as ɵgetLocalePluralCase, LocaleDataIndex as ɵLocaleDataIndex, registerLocaleData as ɵregisterLocaleData, unregisterAllLocaleData as ɵunregisterLocaleData } from './i18n/locale_data_api';
export { DEFAULT_LOCALE_ID as ɵDEFAULT_LOCALE_ID } from './i18n/localization';
export { ComponentFactory as ɵComponentFactory } from './linker/component_factory';
export { clearResolutionOfComponentResourcesQueue as ɵclearResolutionOfComponentResourcesQueue, resolveComponentResources as ɵresolveComponentResources } from './metadata/resource_loading';
export { ReflectionCapabilities as ɵReflectionCapabilities } from './reflection/reflection_capabilities';
export { allowSanitizationBypassAndThrow as ɵallowSanitizationBypassAndThrow, getSanitizationBypassType as ɵgetSanitizationBypassType, unwrapSafeValue as ɵunwrapSafeValue } from './sanitization/bypass';
export { _sanitizeHtml as ɵ_sanitizeHtml } from './sanitization/html_sanitizer';
export { _sanitizeUrl as ɵ_sanitizeUrl } from './sanitization/url_sanitizer';
export { TESTABILITY as ɵTESTABILITY, TESTABILITY_GETTER as ɵTESTABILITY_GETTER } from './testability/testability';
export { coerceToBoolean as ɵcoerceToBoolean } from './util/coercion';
export { devModeEqual as ɵdevModeEqual } from './util/comparison';
export { makeDecorator as ɵmakeDecorator } from './util/decorators';
export { global as ɵglobal } from './util/global';
export { isListLikeIterable as ɵisListLikeIterable } from './util/iterable';
export { isObservable as ɵisObservable, isPromise as ɵisPromise, isSubscribable as ɵisSubscribable } from './util/lang';
export { stringify as ɵstringify } from './util/stringify';
export { NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR as ɵNOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR } from './view/provider_flags';
// TODO(alxhub): allows tests to compile, can be removed when tests have been updated.
export const ɵivyEnabled = true;
//# sourceMappingURL=data:application/json;base64,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