import { shiftDate, formatDate } from 'ngx-bootstrap/chronos';
import { createMatrix } from '../utils/matrix-utils';
const height = 4;
const width = 4;
export const yearsPerCalendar = height * width;
export const initialYearShift = (Math.floor(yearsPerCalendar / 2) - 1) * -1;
const shift = { year: 1 };
export function formatYearsCalendar(viewDate, formatOptions, previousInitialDate) {
    const initialDate = calculateInitialDate(viewDate, previousInitialDate);
    const matrixOptions = { width, height, initialDate, shift };
    const yearsMatrix = createMatrix(matrixOptions, date => ({
        date,
        label: formatDate(date, formatOptions.yearLabel, formatOptions.locale)
    }));
    const yearTitle = formatYearRangeTitle(yearsMatrix, formatOptions);
    return {
        years: yearsMatrix,
        monthTitle: '',
        yearTitle,
        hideLeftArrow: false,
        hideRightArrow: false,
        disableLeftArrow: false,
        disableRightArrow: false
    };
}
function calculateInitialDate(viewDate, previousInitialDate) {
    if (previousInitialDate
        && viewDate.getFullYear() >= previousInitialDate.getFullYear()
        && viewDate.getFullYear() < previousInitialDate.getFullYear() + yearsPerCalendar) {
        return previousInitialDate;
    }
    return shiftDate(viewDate, { year: initialYearShift });
}
function formatYearRangeTitle(yearsMatrix, formatOptions) {
    const from = formatDate(yearsMatrix[0][0].date, formatOptions.yearTitle, formatOptions.locale);
    const to = formatDate(yearsMatrix[height - 1][width - 1].date, formatOptions.yearTitle, formatOptions.locale);
    return `${from} - ${to}`;
}
//# sourceMappingURL=data:application/json;base64,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