import { ElementRef, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges } from '@angular/core';
import { NavigationEnd, Router } from '@angular/router';
import { INavData } from './sidebar-nav';
import { SidebarNavHelper } from './sidebar-nav.service';
import { SidebarService } from '../sidebar.service';
import { SidebarComponent } from '../sidebar/sidebar.component';
import { Observable, Subscription } from 'rxjs';
import * as i0 from "@angular/core";
export declare class SidebarNavComponent implements OnChanges {
    sidebar: SidebarComponent;
    helper: SidebarNavHelper;
    router: Router;
    private renderer;
    private hostElement;
    private sidebarService;
    navItems?: INavData[];
    dropdownMode?: 'closeInactive' | 'noAction' | 'openActive';
    groupItems?: boolean;
    compact?: boolean;
    get hostClasses(): any;
    get sidebarNavGroupItemsClass(): boolean;
    role: string;
    navItemsArray: INavData[];
    constructor(sidebar: SidebarComponent, helper: SidebarNavHelper, router: Router, renderer: Renderer2, hostElement: ElementRef, sidebarService: SidebarService);
    ngOnChanges(changes: SimpleChanges): void;
    hideMobile(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SidebarNavComponent, [{ optional: true; }, null, null, null, null, null]>;
    static ɵcmp: i0.ɵɵComponentDeclaration<SidebarNavComponent, "c-sidebar-nav", never, { "navItems": "navItems"; "dropdownMode": "dropdownMode"; "groupItems": "groupItems"; "compact": "compact"; }, {}, never, ["*"], false>;
}
export declare class SidebarNavGroupComponent implements OnInit, OnDestroy {
    private router;
    helper: SidebarNavHelper;
    private hostElement;
    item: any;
    dropdownMode: 'closeInactive' | 'noAction' | 'openActive';
    show: boolean;
    get hostClasses(): any;
    navigationEndObservable: Observable<NavigationEnd>;
    navSubscription: Subscription;
    private open;
    navItems: INavData[];
    constructor(router: Router, helper: SidebarNavHelper, hostElement: ElementRef);
    ngOnInit(): void;
    samePath(url: string): boolean;
    openGroup(open: boolean): void;
    toggleGroup($event: any): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SidebarNavGroupComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<SidebarNavGroupComponent, "c-sidebar-nav-group", never, { "item": "item"; "dropdownMode": "dropdownMode"; "show": "show"; }, {}, never, never, false>;
}
