import { Component, EventEmitter, HostBinding, HostListener, Inject, Input, Output, PLATFORM_ID, } from '@angular/core';
import { animate, state, style, transition, trigger, } from '@angular/animations';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { DOCUMENT, isPlatformBrowser } from '@angular/common';
import * as i0 from "@angular/core";
import * as i1 from "../offcanvas.service";
import * as i2 from "../../backdrop/backdrop.service";
import * as i3 from "@angular/cdk/a11y";
let nextId = 0;
export class OffcanvasComponent {
    constructor(document, platformId, renderer, hostElement, offcanvasService, backdropService) {
        this.document = document;
        this.platformId = platformId;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.offcanvasService = offcanvasService;
        this.backdropService = backdropService;
        /**
         * Apply a backdrop on body while offcanvas is open.
         * @type boolean
         * @default true
         */
        this.backdrop = true;
        /**
         * Closes the offcanvas when escape key is pressed [docs]
         * @type boolean
         * @default true
         */
        this.keyboard = true;
        /**
         * Components placement, there’s no default placement.
         * @type {'start' | 'end' | 'top' | 'bottom'}
         * @default 'start'
         */
        this.placement = 'start';
        this._scroll = false;
        this.id = `offcanvas-${this.placement}-${nextId++}`;
        /**
         * Default role for offcanvas. [docs]
         * @type string
         * @default 'dialog'
         */
        this.role = 'dialog';
        /**
         * Set aria-modal html attr for offcanvas. [docs]
         * @type boolean
         * @default true
         */
        this.ariaModal = true;
        /**
         * Event triggered on visible change.
         */
        this.visibleChange = new EventEmitter();
    }
    /**
     * Allow body scrolling while offcanvas is visible.
     * @type boolean
     */
    set scroll(value) {
        this._scroll = coerceBooleanProperty(value);
    }
    ;
    get scroll() {
        return this._scroll;
    }
    /**
     * Toggle the visibility of offcanvas component.
     * @type boolean
     */
    set visible(value) {
        this._visible = coerceBooleanProperty(value);
        if (value) {
            this.setBackdrop(this.backdrop);
            this.setFocus();
        }
        else {
            this.setBackdrop(false);
        }
        this.setScroll();
        this.visibleChange.emit(value);
    }
    get visible() {
        return this._visible;
    }
    get hostClasses() {
        return {
            offcanvas: true,
            [`offcanvas-${this.placement}`]: !!this.placement,
            show: this.visible,
        };
    }
    get ariaHidden() {
        return this.visible ? null : true;
    }
    ;
    get tabIndex() {
        return '-1';
    }
    get animateType() {
        return this.visible;
    }
    onKeyDownHandler(event) {
        if (event.key === 'Escape' && this.keyboard && this.visible) {
            this.offcanvasService.toggle({ show: false, id: this.id });
        }
    }
    ngOnInit() {
        this.setScroll();
        this.stateToggleSubscribe();
    }
    ngOnDestroy() {
        this.offcanvasService.toggle({ show: false, id: this.id });
        this.stateToggleSubscribe(false);
    }
    ngOnChanges(changes) {
        if (changes['scroll']) {
            this.setScroll();
        }
    }
    stateToggleSubscribe(subscribe = true) {
        if (subscribe) {
            this.stateToggleSubscription = this.offcanvasService.offcanvasState$.subscribe((action) => {
                if (this === action.offcanvas || this.id === action.id) {
                    if ('show' in action) {
                        this.visible = action?.show === 'toggle' ? !this.visible : action.show;
                    }
                }
            });
        }
        else {
            this.stateToggleSubscription.unsubscribe();
        }
    }
    backdropClickSubscribe(subscribe = true) {
        if (subscribe) {
            this.backdropClickSubscription = this.backdropService.backdropClick$.subscribe((clicked) => {
                this.offcanvasService.toggle({ show: !clicked, id: this.id });
            });
        }
        else {
            this.backdropClickSubscription?.unsubscribe();
        }
    }
    setBackdrop(setBackdrop) {
        if (setBackdrop) {
            this.activeBackdrop = this.backdropService.setBackdrop('offcanvas');
            this.backdropClickSubscribe();
        }
        else {
            this.activeBackdrop = this.backdropService.clearBackdrop(this.activeBackdrop);
            this.backdropClickSubscribe(false);
        }
    }
    setFocus() {
        if (isPlatformBrowser(this.platformId)) {
            setTimeout(() => this.hostElement.nativeElement.focus());
        }
    }
    setScroll() {
        if (this.visible) {
            if (!this.scroll) {
                this.renderer.setStyle(this.document.body, 'overflow', 'hidden');
                this.renderer.setStyle(this.document.body, 'paddingRight.px', '0');
            }
            return;
        }
        if (!this.scroll) {
            this.renderer.removeStyle(this.document.body, 'overflow');
            this.renderer.removeStyle(this.document.body, 'paddingRight');
        }
    }
}
OffcanvasComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: OffcanvasComponent, deps: [{ token: DOCUMENT }, { token: PLATFORM_ID }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i1.OffcanvasService }, { token: i2.BackdropService }], target: i0.ɵɵFactoryTarget.Component });
OffcanvasComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: OffcanvasComponent, selector: "c-offcanvas", inputs: { backdrop: "backdrop", keyboard: "keyboard", placement: "placement", scroll: "scroll", id: "id", role: "role", ariaModal: "ariaModal", visible: "visible" }, outputs: { visibleChange: "visibleChange" }, host: { listeners: { "document:keydown": "onKeyDownHandler($event)" }, properties: { "attr.role": "this.role", "attr.aria-modal": "this.ariaModal", "class": "this.hostClasses", "attr.aria-hidden": "this.ariaHidden", "attr.tabindex": "this.tabIndex", "@showHide": "this.animateType" } }, exportAs: ["cOffcanvas"], usesOnChanges: true, ngImport: i0, template: "<div cdkTrapFocus cdkTrapFocusAutoCapture>\n  <ng-content></ng-content>\n</div>\n\n", styles: [""], dependencies: [{ kind: "directive", type: i3.CdkTrapFocus, selector: "[cdkTrapFocus]", inputs: ["cdkTrapFocus", "cdkTrapFocusAutoCapture"], exportAs: ["cdkTrapFocus"] }], animations: [
        trigger('showHide', [
            state('true', style({
                visibility: 'visible',
            })),
            state('false', style({
                visibility: 'hidden',
            })),
            transition('true => false', [animate('300ms')]),
        ]),
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: OffcanvasComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-offcanvas', animations: [
                        trigger('showHide', [
                            state('true', style({
                                visibility: 'visible',
                            })),
                            state('false', style({
                                visibility: 'hidden',
                            })),
                            transition('true => false', [animate('300ms')]),
                        ]),
                    ], exportAs: 'cOffcanvas', template: "<div cdkTrapFocus cdkTrapFocusAutoCapture>\n  <ng-content></ng-content>\n</div>\n\n" }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PLATFORM_ID]
                }] }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i1.OffcanvasService }, { type: i2.BackdropService }]; }, propDecorators: { backdrop: [{
                type: Input
            }], keyboard: [{
                type: Input
            }], placement: [{
                type: Input
            }], scroll: [{
                type: Input
            }], id: [{
                type: Input
            }], role: [{
                type: Input
            }, {
                type: HostBinding,
                args: ['attr.role']
            }], ariaModal: [{
                type: Input
            }, {
                type: HostBinding,
                args: ['attr.aria-modal']
            }], visible: [{
                type: Input
            }], visibleChange: [{
                type: Output
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], ariaHidden: [{
                type: HostBinding,
                args: ['attr.aria-hidden']
            }], tabIndex: [{
                type: HostBinding,
                args: ['attr.tabindex']
            }], animateType: [{
                type: HostBinding,
                args: ['@showHide']
            }], onKeyDownHandler: [{
                type: HostListener,
                args: ['document:keydown', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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