import { Directive, HostBinding, Input } from '@angular/core';
import * as i0 from "@angular/core";
export class FormLabelDirective {
    constructor() {
        /**
         * For horizontal forms set labels to 'col' and make them vertically centered with their associated form controls.
         * @type 'col'
         */
        this.col = '';
        /**
         * Size the label small or large.
         */
        this.sizing = '';
    }
    get hostClasses() {
        return {
            'form-label': true,
            'col-form-label': this.col === 'col',
            [`col-form-label-${this.sizing}`]: !!this.sizing && this.col === 'col',
        };
    }
}
FormLabelDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormLabelDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
FormLabelDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: FormLabelDirective, selector: "[cLabel]", inputs: { col: ["cLabel", "col"], sizing: "sizing" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormLabelDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cLabel]'
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { col: [{
                type: Input,
                args: ['cLabel']
            }], sizing: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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