import { Component, ContentChild, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { FormCheckLabelDirective } from './form-check-label.directive';
import * as i0 from "@angular/core";
export class FormCheckComponent {
    constructor() {
        this._inline = false;
        /**
         * Size the component large or extra large. Works only with `[switch]="true"` [docs]
         * @type {'lg' | 'xl' | ''}
         */
        this.sizing = '';
        this._switch = false;
        this._formCheckClass = true;
    }
    /**
     * Group checkboxes or radios on the same horizontal row.
     * @type boolean
     * @default false
     */
    set inline(value) {
        this._inline = coerceBooleanProperty(value);
    }
    get inline() {
        return this._inline;
    }
    /**
   * Render a toggle switch on for checkbox.
   * @type boolean
   * @default false
   */
    set switch(value) {
        this._switch = coerceBooleanProperty(value);
    }
    get switch() {
        return this._switch;
    }
    get hostClasses() {
        return {
            'form-check': this.formCheckClass,
            'form-switch': this.switch,
            [`form-switch-${this.sizing}`]: this.switch && !!this.sizing,
            'form-check-inline': this.inline
        };
    }
    get formCheckClass() {
        return this._formCheckClass;
    }
    ngAfterContentInit() {
        this._formCheckClass = !!this.formCheckLabel;
    }
}
FormCheckComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormCheckComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
FormCheckComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: FormCheckComponent, selector: "c-form-check", inputs: { inline: "inline", sizing: "sizing", switch: "switch" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "formCheckLabel", first: true, predicate: FormCheckLabelDirective, descendants: true }], exportAs: ["cFormCheck"], ngImport: i0, template: '<ng-content></ng-content>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormCheckComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-form-check',
                    template: '<ng-content></ng-content>',
                    exportAs: 'cFormCheck'
                }]
        }], propDecorators: { inline: [{
                type: Input
            }], sizing: [{
                type: Input
            }], switch: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], formCheckLabel: [{
                type: ContentChild,
                args: [FormCheckLabelDirective]
            }] } });
//# sourceMappingURL=data:application/json;base64,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