import { Directive, EventEmitter, HostBinding, Input, Output } from '@angular/core';
import { useAnimation } from '@angular/animations';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { collapseAnimation, collapseHorizontalAnimation, expandAnimation, expandHorizontalAnimation } from './collapse.animations';
import * as i0 from "@angular/core";
import * as i1 from "@angular/animations";
// todo
// tslint:disable-next-line:no-conflicting-lifecycle
export class CollapseDirective {
    constructor(hostElement, renderer, animationBuilder) {
        this.hostElement = hostElement;
        this.renderer = renderer;
        this.animationBuilder = animationBuilder;
        this._animate = true;
        this._horizontal = false;
        this._visible = false;
        this._navbar = false;
        /**
         * @ignore
         */
        this.duration = '350ms';
        /**
         * @ignore
         */
        this.transition = 'ease';
        /**
         * Event emitted on visibility change. [docs]
         * @type string
         */
        this.collapseChange = new EventEmitter();
        this.collapsing = false;
        this.host = this.hostElement.nativeElement;
        this.renderer.setStyle(this.host, 'display', 'none');
    }
    /**
     * @ignore
     */
    set animate(value) {
        this._animate = value;
    }
    get animate() {
        return this._animate;
    }
    /**
     * Set horizontal collapsing to transition the width instead of height.
     */
    set horizontal(value) {
        this._horizontal = coerceBooleanProperty(value);
    }
    get horizontal() {
        return this._horizontal;
    }
    /**
     * Toggle the visibility of collapsible element.
     */
    set visible(value) {
        this._visible = value;
    }
    get visible() {
        return this._visible;
    }
    /**
     * Add `navbar` prop for grouping and hiding navbar contents by a parent breakpoint.
     */
    set navbar(value) {
        this._navbar = coerceBooleanProperty(value);
    }
    ;
    get navbar() {
        return this._navbar;
    }
    get hostClasses() {
        return {
            'navbar-collapse': this.navbar,
            show: this.visible,
            'collapse-horizontal': this.horizontal,
            collapsing: this.collapsing
            // collapse: !this.collapsing && !this.visible
        };
    }
    ngAfterViewInit() {
        if (this.visible) {
            this.toggle();
        }
    }
    ngOnDestroy() {
        this.destroyPlayer();
    }
    ngOnChanges(changes) {
        if (changes['visible']) {
            if (!changes['visible'].firstChange || !changes['visible'].currentValue) {
                this.toggle(changes['visible'].currentValue);
            }
        }
    }
    ngDoCheck() {
        if (this._visible !== this.visible) {
            this.toggle();
        }
    }
    toggle(visible = this.visible) {
        this.createPlayer(visible);
        this.player?.play();
    }
    destroyPlayer() {
        this.player?.destroy();
    }
    createPlayer(visible = this.visible) {
        if (this.player?.hasStarted()) {
            this.destroyPlayer();
        }
        if (visible) {
            this.renderer.removeStyle(this.host, 'display');
        }
        const duration = this.animate ? this.duration : '0ms';
        const expand = this.horizontal ? expandHorizontalAnimation : expandAnimation;
        const collapse = this.horizontal ? collapseHorizontalAnimation : collapseAnimation;
        const animationFactory = this.animationBuilder.build(useAnimation(visible ? expand : collapse, { params: { time: duration, easing: this.transition } }));
        this.player = animationFactory.create(this.host);
        this.player.onStart(() => {
            this.setMaxSize();
            this.visible = visible;
            this.collapsing = true;
            this.collapseChange.emit(visible ? 'opening' : 'collapsing');
        });
        this.player.onDone(() => {
            this.collapsing = false;
            this.collapseChange.emit(visible ? 'open' : 'collapsed');
        });
    }
    setMaxSize() {
        setTimeout(() => {
            if (this.horizontal) {
                this.scrollWidth = this.host.scrollWidth;
                this.scrollWidth > 0 && this.renderer.setStyle(this.host, 'maxWidth', `${this.scrollWidth}px`);
                // } else {
                // this.scrollHeight = this.host.scrollHeight;
                // this.scrollHeight > 0 && this.renderer.setStyle(this.host, 'maxHeight', `${this.scrollHeight}px`);
            }
        });
    }
}
CollapseDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CollapseDirective, deps: [{ token: i0.ElementRef }, { token: i0.Renderer2 }, { token: i1.AnimationBuilder }], target: i0.ɵɵFactoryTarget.Directive });
CollapseDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: CollapseDirective, selector: "[cCollapse]", inputs: { animate: "animate", horizontal: "horizontal", visible: "visible", navbar: "navbar", duration: "duration", transition: "transition" }, outputs: { collapseChange: "collapseChange" }, host: { properties: { "class": "this.hostClasses" } }, exportAs: ["cCollapse"], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CollapseDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cCollapse]',
                    exportAs: 'cCollapse'
                }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i1.AnimationBuilder }]; }, propDecorators: { animate: [{
                type: Input
            }], horizontal: [{
                type: Input
            }], visible: [{
                type: Input
            }], navbar: [{
                type: Input
            }], duration: [{
                type: Input
            }], transition: [{
                type: Input
            }], collapseChange: [{
                type: Output
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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