import { Component, EventEmitter, HostBinding, Inject, Input, Output } from '@angular/core';
import { IntersectionService } from '../../services/intersection.service';
import { ListenersService } from '../../services/listeners.service';
import { CarouselState } from '../carousel-state';
import { CarouselService } from '../carousel.service';
import { CarouselConfig } from '../carousel.config';
import * as i0 from "@angular/core";
import * as i1 from "../carousel.service";
import * as i2 from "../carousel-state";
import * as i3 from "../../services/intersection.service";
import * as i4 from "../../services/listeners.service";
import * as i5 from "../carousel.config";
export class CarouselComponent {
    constructor(config, hostElement, carouselService, carouselState, intersectionService, listenersService) {
        this.config = config;
        this.hostElement = hostElement;
        this.carouselService = carouselService;
        this.carouselState = carouselState;
        this.intersectionService = intersectionService;
        this.listenersService = listenersService;
        /**
         * Index of the active item.
         * @type number
         */
        this.activeIndex = 0;
        /**
         * Carousel automatically starts cycle items.
         * @type boolean
         */
        this.animate = true;
        /**
         * Carousel direction. [docs]
         * @type {'next' | 'prev'}
         */
        this.direction = 'next';
        /**
         * The amount of time to delay between automatically cycling an item. If false, carousel will not automatically cycle.
         * @type number
         * @default 0
         */
        this.interval = 0;
        /**
         * Sets which event handlers you’d like provided to your pause prop. You can specify one trigger or an array of them.
         * @type {'hover' | 'focus' | 'click'}
         */
        this.pause = 'hover';
        /**
         * Set type of the transition.
         * @type {'slide' | 'crossfade'}
         * @default 'slide'
         */
        this.transition = 'slide';
        /**
         * Set whether the carousel should cycle continuously or have hard stops.
         * @type boolean
         * @default true
         */
        this.wrap = true;
        /**
         * Event emitted on carousel item change. [docs]
         * @type number
         */
        this.itemChange = new EventEmitter();
        this.activeItemInterval = 0;
        this._visible = true;
        Object.assign(this, config);
    }
    get hostClasses() {
        return {
            carousel: true,
            slide: true,
            'carousel-dark': !!this.dark,
            'carousel-fade': this.transition === 'crossfade'
        };
    }
    ngOnInit() {
        this.carouselStateSubscribe();
    }
    ngOnDestroy() {
        this.clearListeners();
        this.carouselStateSubscribe(false);
        this.intersectionServiceSubscribe(false);
    }
    ngAfterContentInit() {
        this.intersectionService.createIntersectionObserver(this.hostElement);
        this.intersectionServiceSubscribe();
        this.carouselState.state = { activeItemIndex: this.activeIndex, animate: this.animate };
        this.setListeners();
    }
    setListeners() {
        const config = {
            hostElement: this.hostElement,
            trigger: this.pause || [],
            callbackOff: () => {
                this.setTimer();
            },
            callbackOn: () => {
                this.resetTimer();
            }
        };
        this.listenersService.setListeners(config);
    }
    clearListeners() {
        this.listenersService.clearListeners();
    }
    set visible(value) {
        this._visible = value;
    }
    get visible() {
        return this._visible;
    }
    setTimer() {
        const interval = this.activeItemInterval || 0;
        this.resetTimer();
        if (interval > 0) {
            this.timerId = setTimeout(() => {
                const nextIndex = this.carouselState.direction(this.direction);
                this.carouselState.state = { activeItemIndex: nextIndex };
            }, interval);
        }
    }
    resetTimer() {
        clearTimeout(this.timerId);
    }
    carouselStateSubscribe(subscribe = true) {
        if (subscribe) {
            this.carouselIndexSubscription = this.carouselService.carouselIndex$.subscribe((nextItem) => {
                if ('active' in nextItem) {
                    this.itemChange.emit(nextItem.active);
                }
                this.activeItemInterval = typeof nextItem.interval === 'number' && nextItem.interval > -1 ? nextItem.interval : this.interval;
                const isLastItem = ((nextItem.active === nextItem.lastItemIndex) && this.direction === 'next') || ((nextItem.active === 0) && this.direction === 'prev');
                !this.wrap && isLastItem ? this.resetTimer() : this.setTimer();
            });
        }
        else {
            this.carouselIndexSubscription?.unsubscribe();
        }
    }
    intersectionServiceSubscribe(subscribe = true) {
        if (subscribe) {
            this.intersectingSubscription = this.intersectionService.intersecting$.subscribe(isIntersecting => {
                this.visible = isIntersecting;
                isIntersecting ? this.setTimer() : this.resetTimer();
            });
        }
        else {
            this.intersectingSubscription?.unsubscribe();
        }
    }
}
CarouselComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselComponent, deps: [{ token: CarouselConfig }, { token: i0.ElementRef }, { token: i1.CarouselService }, { token: i2.CarouselState }, { token: i3.IntersectionService }, { token: i4.ListenersService }], target: i0.ɵɵFactoryTarget.Component });
CarouselComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: CarouselComponent, selector: "c-carousel", inputs: { activeIndex: "activeIndex", animate: "animate", dark: "dark", direction: "direction", interval: "interval", pause: "pause", transition: "transition", wrap: "wrap" }, outputs: { itemChange: "itemChange" }, host: { properties: { "class": "this.hostClasses" } }, providers: [CarouselService, CarouselState, CarouselConfig, IntersectionService, ListenersService], ngImport: i0, template: '<ng-content></ng-content>', isInline: true, styles: [":host{display:block}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-carousel', template: '<ng-content></ng-content>', providers: [CarouselService, CarouselState, CarouselConfig, IntersectionService, ListenersService], styles: [":host{display:block}\n"] }]
        }], ctorParameters: function () { return [{ type: i5.CarouselConfig, decorators: [{
                    type: Inject,
                    args: [CarouselConfig]
                }] }, { type: i0.ElementRef }, { type: i1.CarouselService }, { type: i2.CarouselState }, { type: i3.IntersectionService }, { type: i4.ListenersService }]; }, propDecorators: { activeIndex: [{
                type: Input
            }], animate: [{
                type: Input
            }], dark: [{
                type: Input
            }], direction: [{
                type: Input
            }], interval: [{
                type: Input
            }], pause: [{
                type: Input
            }], transition: [{
                type: Input
            }], wrap: [{
                type: Input
            }], itemChange: [{
                type: Output
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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